<?php
// Exit if accessed directly
if ( !defined( 'ABSPATH' ) ) exit;

// Overwrite parent theme background defaults and registers support for WordPress features.
add_action( 'after_setup_theme', 'lalita_background_setup' );
function lalita_background_setup() {
	add_theme_support( "custom-background",
		array(
			'default-color' 		 => '000000',
			'default-image'          => '',
			'default-repeat'         => 'repeat',
			'default-position-x'     => 'left',
			'default-position-y'     => 'top',
			'default-size'           => 'auto',
			'default-attachment'     => '',
			'wp-head-callback'       => '_custom_background_cb',
			'admin-head-callback'    => '',
			'admin-preview-callback' => ''
		)
	);
}

// Overwrite theme URL
function lalita_theme_uri_link() {
	return 'https://wpkoi.com/mahatma-wpkoi-wordpress-theme/';
}

// Overwrite parent theme's blog header function
add_action( 'lalita_after_header', 'lalita_blog_header_image', 11 );
function lalita_blog_header_image() {

	if ( ( is_front_page() && is_home() ) || ( is_home() ) ) { 
		$blog_header_image 			=  lalita_get_setting( 'blog_header_image' ); 
		$blog_header_title 			=  lalita_get_setting( 'blog_header_title' ); 
		$blog_header_text 			=  lalita_get_setting( 'blog_header_text' ); 
		$blog_header_button_text 	=  lalita_get_setting( 'blog_header_button_text' ); 
		$blog_header_button_url 	=  lalita_get_setting( 'blog_header_button_url' ); 
		if ( $blog_header_image != '' ) { ?>
		<div class="page-header-image grid-parent page-header-blog" style="background-image: url('<?php echo esc_url($blog_header_image); ?>') !important;">
        	<div class="page-header-noiseoverlay"></div>
        	<div class="page-header-blog-inner">
                <div class="page-header-blog-content-h grid-container">
                    <div class="page-header-blog-content">
                    <?php if ( $blog_header_title != '' ) { ?>
                        <div class="page-header-blog-text">
                            <?php if ( $blog_header_title != '' ) { ?>
                            <h2><?php echo wp_kses_post( $blog_header_title ); ?></h2>
                            <div class="clearfix"></div>
                            <?php } ?>
                        </div>
                    <?php } ?>
                    </div>
                </div>
                <div class="page-header-blog-content page-header-blog-content-b">
                	<?php if ( $blog_header_text != '' ) { ?>
                	<div class="page-header-blog-text">
						<?php if ( $blog_header_title != '' ) { ?>
                        <p><?php echo wp_kses_post( $blog_header_text ); ?></p>
                        <div class="clearfix"></div>
                        <?php } ?>
                    </div>
                    <?php } ?>
                    <div class="page-header-blog-button">
                        <?php if ( $blog_header_button_text != '' ) { ?>
                        <a class="read-more button" href="<?php echo esc_url( $blog_header_button_url ); ?>"><?php echo esc_html( $blog_header_button_text ); ?></a>
                        <?php } ?>
                    </div>
                </div>
            </div>
		</div>
		<?php
		}
	}
}

// Extra cutomizer functions
if ( ! function_exists( 'mahatma_customize_register' ) ) {
	add_action( 'customize_register', 'mahatma_customize_register' );
	function mahatma_customize_register( $wp_customize ) {
				
		// Add Mahatma customizer section
		$wp_customize->add_section(
			'mahatma_layout_effects',
			array(
				'title' => __( 'Mahatma Effects', 'mahatma' ),
				'priority' => 24,
			)
		);
		
		
		// Logo effect
		$wp_customize->add_setting(
			'mahatma_settings[logo_effect]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'mahatma_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'mahatma_settings[logo_effect]',
			array(
				'type' => 'select',
				'label' => __( 'Logo effect', 'mahatma' ),
				'choices' => array(
					'enable' => __( 'Enable', 'mahatma' ),
					'disable' => __( 'Disable', 'mahatma' )
				),
				'settings' => 'mahatma_settings[logo_effect]',
				'section' => 'mahatma_layout_effects',
				'priority' => 1
			)
		);
		
		
		// Navigation effect
		$wp_customize->add_setting(
			'mahatma_settings[nav_effect]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'mahatma_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'mahatma_settings[nav_effect]',
			array(
				'type' => 'select',
				'label' => __( 'Navigation effect', 'mahatma' ),
				'choices' => array(
					'enable' => __( 'Enable', 'mahatma' ),
					'disable' => __( 'Disable', 'mahatma' )
				),
				'settings' => 'mahatma_settings[nav_effect]',
				'section' => 'mahatma_layout_effects',
				'priority' => 1
			)
		);
		
		// Top bar button style
		$wp_customize->add_setting(
			'mahatma_settings[tbb_style]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'mahatma_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'mahatma_settings[tbb_style]',
			array(
				'type' => 'select',
				'label' => __( 'Top bar button style', 'mahatma' ),
				'choices' => array(
					'enable' => __( 'Enable', 'mahatma' ),
					'disable' => __( 'Disable', 'mahatma' )
				),
				'settings' => 'mahatma_settings[tbb_style]',
				'section' => 'mahatma_layout_effects',
				'priority' => 3
			)
		);
		
		// Blog title effect
		$wp_customize->add_setting(
			'mahatma_settings[blog_title_effect]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'mahatma_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'mahatma_settings[blog_title_effect]',
			array(
				'type' => 'select',
				'label' => __( 'Blog title effect', 'mahatma' ),
				'choices' => array(
					'enable' => __( 'Enable', 'mahatma' ),
					'disable' => __( 'Disable', 'mahatma' )
				),
				'settings' => 'mahatma_settings[blog_title_effect]',
				'section' => 'mahatma_layout_effects',
				'priority' => 2
			)
		);
		
		// Nicescroll
		$wp_customize->add_setting(
			'mahatma_settings[nicescroll]',
			array(
				'default' => 'enable',
				'type' => 'option',
				'sanitize_callback' => 'mahatma_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'mahatma_settings[nicescroll]',
			array(
				'type' => 'select',
				'label' => __( 'Mahatma scrollbar style', 'mahatma' ),
				'choices' => array(
					'enable' => __( 'Enable', 'mahatma' ),
					'disable' => __( 'Disable', 'mahatma' )
				),
				'settings' => 'mahatma_settings[nicescroll]',
				'section' => 'mahatma_layout_effects',
				'priority' => 8
			)
		);
		
		
		// Mahatma effect colors
		$wp_customize->add_setting(
			'mahatma_settings[mahatma_color_1]', array(
				'default' => '#ffffff',
				'type' => 'option',
				'sanitize_callback' => 'mahatma_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'mahatma_settings[mahatma_color_1]',
				array(
					'label' => __( 'Color 1 for Mahatma effects', 'mahatma' ),
					'section' => 'mahatma_layout_effects',
					'settings' => 'mahatma_settings[mahatma_color_1]',
					'description' => __( 'Colors for logo effect, navigation effects, scrollbar, blog title', 'mahatma' ),
					'priority' => 31
				)
			)
		);
		
		$wp_customize->add_setting(
			'mahatma_settings[mahatma_color_2]', array(
				'default' => '#ee2222',
				'type' => 'option',
				'sanitize_callback' => 'mahatma_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'mahatma_settings[mahatma_color_2]',
				array(
					'label' => __( 'Color 2 for Mahatma effects', 'mahatma' ),
					'section' => 'mahatma_layout_effects',
					'settings' => 'mahatma_settings[mahatma_color_2]',
					'description' => __( 'Colors for logo effect, navigation effects, scrollbar, blog title', 'mahatma' ),
					'priority' => 32
				)
			)
		);
		
		$wp_customize->add_setting(
			'mahatma_settings[mahatma_color_3]', array(
				'default' => '#fc4e4e',
				'type' => 'option',
				'sanitize_callback' => 'mahatma_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'mahatma_settings[mahatma_color_3]',
				array(
					'label' => __( 'Color 3 for Mahatma effects', 'mahatma' ),
					'section' => 'mahatma_layout_effects',
					'settings' => 'mahatma_settings[mahatma_color_3]',
					'description' => __( 'Colors for logo effect, navigation effects, scrollbar, blog title', 'mahatma' ),
					'priority' => 33
				)
			)
		);
		
		$wp_customize->add_setting(
			'mahatma_settings[mahatma_color_4]', array(
				'default' => '#000000',
				'type' => 'option',
				'sanitize_callback' => 'mahatma_sanitize_hex_color',
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Color_Control(
				$wp_customize,
				'mahatma_settings[mahatma_color_4]',
				array(
					'label' => __( 'Color 4 for Mahatma effects', 'mahatma' ),
					'section' => 'mahatma_layout_effects',
					'settings' => 'mahatma_settings[mahatma_color_4]',
					'description' => __( 'Colors for logo effect, navigation effects, scrollbar, blog title', 'mahatma' ),
					'priority' => 34
				)
			)
		);
	}
}

//Sanitize choices.
if ( ! function_exists( 'mahatma_sanitize_choices' ) ) {
	function mahatma_sanitize_choices( $input, $setting ) {
		// Ensure input is a slug
		$input = sanitize_key( $input );

		// Get list of choices from the control
		// associated with the setting
		$choices = $setting->manager->get_control( $setting->id )->choices;

		// If the input is a valid key, return it;
		// otherwise, return the default
		return ( array_key_exists( $input, $choices ) ? $input : $setting->default );
	}
}

// Sanitize colors. Allow blank value.
if ( ! function_exists( 'mahatma_sanitize_hex_color' ) ) {
	function mahatma_sanitize_hex_color( $color ) {
	    if ( '' === $color ) {
	        return '';
		}

	    // 3 or 6 hex digits, or the empty string.
	    if ( preg_match('|^#([A-Fa-f0-9]{3}){1,2}$|', $color ) ) {
	        return $color;
		}

	    return '';
	}
}

// Mahatma effects colors css
if ( ! function_exists( 'mahatma_effect_colors_css' ) ) {
	function mahatma_effect_colors_css() {
		// Get Customizer settings
		$mahatma_settings = get_option( 'mahatma_settings' );
		
		$mahatma_color_1  	  = '#ffffff';
		$mahatma_color_2  	  = '#ee2222';
		$mahatma_color_3  	  = '#fc4e4e';
		$mahatma_color_4  	  = '#000000';
		if ( isset( $mahatma_settings['mahatma_color_1'] ) ) {
			$mahatma_color_1 = $mahatma_settings['mahatma_color_1'];
		}
		if ( isset( $mahatma_settings['mahatma_color_2'] ) ) {
			$mahatma_color_2 = $mahatma_settings['mahatma_color_2'];
		}
		if ( isset( $mahatma_settings['mahatma_color_3'] ) ) {
			$mahatma_color_3 = $mahatma_settings['mahatma_color_3'];
		}
		if ( isset( $mahatma_settings['mahatma_color_4'] ) ) {
			$mahatma_color_4 = $mahatma_settings['mahatma_color_4'];
		}
		
		$mahatma_navcolors = '.mahatma-nav-effect .main-navigation .main-nav ul li a .char:before {color: ' . esc_attr( $mahatma_color_2 ) . ';}.mahatma-nav-effect .main-navigation .main-nav ul li a .char:after { color: ' . esc_attr( $mahatma_color_3 ) . ';}.mahatma-nav-effect .main-navigation .main-nav ul li a:hover .char {color: ' . esc_attr( $mahatma_color_1 ) . ';}.mahatma-tbb-style .top-bar .widget_nav_menu li a, .mahatma-tbb-style .site-info .widget_nav_menu li a {background: ' . esc_attr( $mahatma_color_2 ) . ';color: ' . esc_attr( $mahatma_color_1 ) . ';}.mahatma-tbb-style .top-bar .widget_nav_menu li a:hover, .mahatma-tbb-style .site-info .widget_nav_menu li a:hover {background: ' . esc_attr( $mahatma_color_3 ) . ';}.mahatma-scrollbar-style::-webkit-scrollbar-track {background: ' . esc_attr( $mahatma_color_4 ) . ';}.mahatma-scrollbar-style::-webkit-scrollbar-thumb {background: ' . esc_attr( $mahatma_color_2 ) . ';border: 1px solid ' . esc_attr( $mahatma_color_4 ) . ';}.mahatma-scrollbar-style::-webkit-scrollbar-thumb:hover {background: ' . esc_attr( $mahatma_color_1 ) . ';}.mahatma-blog-title-effect article .entry-header .entry-title a {background-image: linear-gradient(transparent calc(65% - 5px), ' . esc_attr( $mahatma_color_2 ) . ' 5px);color: ' . esc_attr( $mahatma_color_2 ) . ';}.mahatma-blog-title-effect article .entry-header .entry-title:hover a {color: ' . esc_attr( $mahatma_color_1 ) . ';} .mahatma-logo-effect .main-title a::after {background-image: repeating-linear-gradient( 135deg, transparent 0, transparent 2px, ' . esc_attr( $mahatma_color_1 ) . ' 2px, ' . esc_attr( $mahatma_color_1 ) . ' 3px );} .mahatma-logo-effect .main-title a::before {background-image: repeating-linear-gradient( 45deg, transparent 0, transparent 2px, ' . esc_attr( $mahatma_color_1 ) . ' 2px, ' . esc_attr( $mahatma_color_1 ) . ' 3px );} .mahatma-logo-effect .main-title a::before, .mahatma-logo-effect .main-title a::after {content: "' . esc_attr( get_bloginfo( 'name' ) ) . '";}';
		
		return $mahatma_navcolors;
	}
}


// The dynamic styles of the parent theme added inline to the parent stylesheet.
// For the customizer functions it is better to enqueue after the child theme stylesheet.
if ( ! function_exists( 'mahatma_remove_parent_dynamic_css' ) ) {
	add_action( 'init', 'mahatma_remove_parent_dynamic_css' );
	function mahatma_remove_parent_dynamic_css() {
		remove_action( 'wp_enqueue_scripts', 'lalita_enqueue_dynamic_css', 50 );
	}
}

// Enqueue this CSS after the child stylesheet, not after the parent stylesheet.
if ( ! function_exists( 'mahatma_enqueue_parent_dynamic_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'mahatma_enqueue_parent_dynamic_css', 50 );
	function mahatma_enqueue_parent_dynamic_css() {
		$css = lalita_base_css() . lalita_font_css() . lalita_advanced_css() . lalita_spacing_css() . lalita_no_cache_dynamic_css() .mahatma_effect_colors_css();

		// escaped secure before in parent theme
		wp_add_inline_style( 'lalita-child', $css );
	}
}

//Adds custom classes to the array of body classes.
if ( ! function_exists( 'mahatma_body_classes' ) ) {
	add_filter( 'body_class', 'mahatma_body_classes' );
	function mahatma_body_classes( $classes ) {
		// Get Customizer settings
		$mahatma_settings = get_option( 'mahatma_settings' );
		
		$logo_effect 	   = 'enable';
		$nav_effect 	   = 'enable';
		$blog_title_effect = 'enable';
		$tbb_style  	   = 'enable';
		$nicescroll  	   = 'enable';
		
		if ( isset( $mahatma_settings['logo_effect'] ) ) {
			$logo_effect = $mahatma_settings['logo_effect'];
		}
		
		if ( isset( $mahatma_settings['nav_effect'] ) ) {
			$nav_effect = $mahatma_settings['nav_effect'];
		}
		
		if ( isset( $mahatma_settings['blog_title_effect'] ) ) {
			$blog_title_effect = $mahatma_settings['blog_title_effect'];
		}
		
		if ( isset( $mahatma_settings['tbb_style'] ) ) {
			$tbb_style = $mahatma_settings['tbb_style'];
		}
		
		if ( isset( $mahatma_settings['nicescroll'] ) ) {
			$nicescroll = $mahatma_settings['nicescroll'];
		}
		
		// Logo effect
		if ( $logo_effect != 'disable' ) {
			$classes[] = 'mahatma-logo-effect';
		}
		
		// Navigation effect
		if ( $nav_effect != 'disable' ) {
			$classes[] = 'mahatma-nav-effect';
		}
		
		// Blog title effect
		if ( $blog_title_effect != 'disable' ) {
			$classes[] = 'mahatma-blog-title-effect';
		}
		
		// Top bar button style
		if ( $tbb_style != 'disable' ) {
			$classes[] = 'mahatma-tbb-style';
		}
		
		// Scrollbar style function
		if ( $nicescroll != 'disable' ) {
			$classes[] = 'mahatma-scrollbar-style';
		}
		
		return $classes;
	}
}

if ( ! function_exists( 'mahatma_scripts' ) ) {
	add_action( 'wp_enqueue_scripts', 'mahatma_scripts' );
	/**
	 * Enqueue script
	 */
	function mahatma_scripts() {
		
		$mahatma_settings = get_option( 'mahatma_settings' );
		
		$nav_effect  = 'enable';
		if ( isset( $mahatma_settings['nav_effect'] ) ) {
			$nav_effect = $mahatma_settings['nav_effect'];
		}
		
		if ( $nav_effect != 'disable' ) {
			wp_enqueue_style( 'mahatma-splitting-css', esc_url( get_stylesheet_directory_uri() ) . "/css/splitting.min.css", false, LALITA_VERSION, 'all' );
			wp_enqueue_script( 'mahatma-splitting-js', esc_url( get_stylesheet_directory_uri() ) . "/js/splitting.min.js", array( 'jquery'), LALITA_VERSION, true );
		}
		
	}
}