<?php
/**
 * Magvibe functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Magvibe
 */

if ( ! function_exists( 'magty_add_new_read_more_styles' ) ) :
	function magty_add_new_read_more_styles( $styles ) {
		return array_merge(
			$styles,
			array(
				'style_4' => __( 'Style 4', 'magty' ),
			)
		);
	}
endif;
add_filter( 'magty_read_more_styles', 'magty_add_new_read_more_styles' );

function magvibe_set_theme_mods() {

	$fresh_site_activate = get_option( 'magvibe_site_activate' );
	if ( (bool) $fresh_site_activate === false ) {
	
		$options = array(
			'accent_color'                               => '#567b95',
			'link_color'                                 => '#567b95',
			'link_color_hover'                           => '#567b95',
			'header_social_links_label_color'            => '#000000',
			'header_social_links_icons_color'            => '#000000',
			'header_social_links_icons_hover_color'      => '#567b95',
			'header_search_btn_bg_color'                 => '#567b95',
			'header_btn_one_bg_color'                    => '#567b95',
			'header_btn_one_border_color'                => '#567b95',
			'preloader_color'                            => '#567b95',
			'progressbar_color'                          => '#567b95',
			'breadcrumb_link_color'                      => '#567b95',
			'global_buttons_bg_color'                    => '#567b95',
			'global_buttons_border_color'                => '#567b95',
			'global_post_meta_icons_color'               => '#567b95',
			'ticker_label_bg_color'                      => '#567b95',
			'scroll_to_top_bg_color'                     => '#567b95',
			'scroll_to_top_hover_bg_color'               => '#567b95',
			'top_bar_nav_menu_hover_color'               => '#567b95',
			'primary_font'                               => '"Diphylleia", "regular", serif',
			'primary_font_weight'                        => 700,
			'secondary_font'                             => '"Literata", "200:300:regular:500:600:700:800:900:200italic:300italic:italic:500italic:600italic:700italic:800italic:900italic", serif',
			'secondary_font_weight'                      => 'normal',
			'primary_menu_font'                          => '"Libre Franklin", "100:200:300:regular:500:600:700:800:900:100italic:200italic:300italic:italic:500italic:600italic:700italic:800italic:900italic", sans-serif',
			'primary_menu_font_weight'                   => 400,
			'sub_menu_font'                              => '"Libre Franklin", "100:200:300:regular:500:600:700:800:900:100italic:200italic:300italic:italic:500italic:600italic:700italic:800italic:900italic", sans-serif',
			'sub_menu_font_weight'                       => 400,
			'single_category_style'                      => 'style_3',
			'single_category_color_display'              => 'as_bg',
			'enable_single_tag_label'                    => false,
			'posts_navigation_style'                     => 'style_1',
			'show_author_info'                           => false,
			'show_author_posts'                          => false,
			'show_related_posts'                         => true,
			'pagination_type'                            => 'numeric',
			'center_aligned_pagination'                  => false,
			'enable_top_bar'                             => false,
			'footer_theme'                               => 'light',
			'footer_bg_color'                            => '#ffffff',
			'sub_footer_theme'                           => 'light',
			'sub_footer_bg_color'                        => '#f5f5f5',
			'enable_border_above_sub_footer'             => false,
			'primary_menu_bg_color'                      => '#ffffff',
			'offcanvas_icon_color'                       => '#000000',
			'primary_menu_text_color'                    => '#000000',
			'primary_menu_text_hover_color'              => '#000000',
			'primary_menu_text_hover_border'             => '#567b95',
			'primary_menu_active_item_color'             => '#000000',
			'primary_menu_active_item_border'            => '#567b95',
			'primary_menu_desc_color'                    => '#13466a',
			'sub_menu_text_hover_color'                  => '#567b95',
			'enable_top_border_menu_bar'                 => true,
			'enable_bottom_border_menu_bar'              => true,
			'primary_color'                              => '#5a5a5a',
			'enable_header_btn_one'                      => true,
			'header_btn_one_icon'                        => 'envelope-fill',
			'show_menu_bar_social_nav'                   => true,
			'footer_column_layout'                       => 'footer_layout_1',
		);
	
		foreach ( $options as $key => $value ) {
			set_theme_mod( $key, $value );
		}
	
		update_option( 'magvibe_site_activate', true );
	}
}
add_action( 'after_switch_theme', 'magvibe_set_theme_mods' );