<?php

/**
 * Magic Theme dashboard info
 *
 * The info will be very helpfull for theme user
 *
 * @package Magic Elementor
 */

class magicElementorUserInfo
{
	/**
	 * The slug name to refer to this menu by.
	 *
	 * @var string $menu_slug The menu slug.
	 */
	public $slug = 'magic-elementor';
	/**
	 * Constructor.
	 */
	public function __construct()
	{
		add_action('admin_notices', array($this, 'notice'));
		add_action('admin_notices', array($this, 'review_check'));
		add_action('admin_notices', array($this, 'proaddon_info'));
		add_action('admin_enqueue_scripts', array($this, 'admin_info_assets'));
		add_action('wp_ajax_dismissopenot', array($this, 'welcome_video_infohide'));
		add_action('switch_theme', array($this, 'change_the_theme'));
		add_action('admin_menu', array($this, 'add_documentation_page'));
	}

	/**
	 * Html Notice
	 */
	public function notice()
	{
		global $pagenow;
		$screen = get_current_screen();
		$admin_info = get_option('mge-admin-winfo1');
		if ($admin_info) {
			return;
		}

		if ('themes.php' === $pagenow && 'themes' === $screen->base) {

?>
			<div class="mgadin-notice notice notice-success mgadin-theme-dashboard mgadin-theme-dashboard-notice mge is-dismissible meis-dismissible">
				<?php $this->mgrev_output();
				?>
			</div>
		<?php

		}
	}

	function change_the_theme()
	{
		delete_option('mge-admin-winfo');
	}


	/**
	 * Html Hero
	 *
	 * @param string $location The location.
	 */
	public function mgrev_output()
	{

		?>
		<div class="mgadin-hero">
			<div class="mge-info-content">
				<div class="mge-info-hello">
					<?php esc_html_e('Hello, ', 'magic-elementor'); ?>

					<?php
					$current_user = wp_get_current_user();
					$video_link = 'https://www.youtube.com/watch?v=jTEckmVe9dE';

					echo esc_html($current_user->display_name);
					?>

					<?php esc_html_e('👋🏻', 'magic-elementor'); ?>
				</div>

				<div class="mge-info-title">
					<?php esc_html_e('Welcome to Magic Elementor', 'magic-elementor'); ?>
				</div>
				<div class="mge-info-desc">
					<?php esc_html_e('Thanks for choosing Magic Elementor. We recommend that you see the Magic Elementor Theme Guide Video to know the basics of Magic Elementor.', 'magic-elementor'); ?>
				</div>
				<div class="mge-info-actions">
					<a href="<?php echo esc_url($video_link); ?>" target="_blank" class="button button-primary">
						<?php esc_html_e('Theme Guide Video', 'magic-elementor'); ?>
						<i class="dashicons dashicons-video-alt3"></i>
					</a>
					<a href="<?php echo esc_url(admin_url('themes.php?page=magic-elementor-documentation')); ?>" class="button button-secondary">
						<?php esc_html_e('View Documentation', 'magic-elementor'); ?>
						<i class="dashicons dashicons-book-alt"></i>
					</a>
				</div>

			</div>

			<div class="mge-info-image">
				<span>
					<img src="<?php echo esc_url(get_template_directory_uri() . '/assets/img/info-banner.jpg'); ?>">
				</span>
			</div>
		</div>
	<?php
	}
	/**
	 * Html Hero
	 *
	 * @param string $location The location.
	 */
	public function review_check()
	{
		global $pagenow;
		$screen = get_current_screen();
		$rev_info = get_option('mge_admin_reve4');

		if ($rev_info) {
			return;
		}

		$install_date = get_option('magicelementor_install_date');
		if (!empty($install_date)) {
			$install_day = round((time() - strtotime($install_date)) / 24 / 60 / 60);
			if ($install_day < 3) {
				return;
			}
		}



	?>
		<div class="mgele-notice notice notice-success mgadin-theme-dashboard mgadin-theme-dashboard-notice mge is-dismissible">
			<div class="mgadin-hero">
				<div class="mge-info-content mge-info-rev">
					<div class="mge-info-hello">
						<?php
						esc_html_e('Hi , ', 'magic-elementor');
						$current_user = wp_get_current_user();
						$video_link = 'https://wordpress.org/support/plugin/magical-addons-for-elementor/reviews/?filter=5';

						echo esc_html($current_user->display_name);
						?>

						<?php esc_html_e('👋🏻', 'magic-elementor'); ?>
					</div>

					<div class="mge-info-rev-item">
						<strong><?php esc_html_e('Thank you for using Magic Elementor WordPress Theme', 'magic-elementor'); ?></strong>
					</div>
					<div class="mge-info-desc">
						<strong> <?php esc_html_e('A 5 stars review would be very helpful for me and encourage me a lot for adding more features in the Magic Elementor plugin. Hope you will give me five stars and stay with us.', 'magic-elementor'); ?>
						</strong>
					</div>
					<div class="mge-info-actions mgerev-action">
						<a href="<?php echo esc_url($video_link); ?>" target="_blank" class="button button-primary">
							<?php esc_html_e('Yes, you deserve it', 'magic-elementor'); ?>
							<i class="dashicons dashicons-star-filled"></i>
						</a>
						<button class="button mgrev-hide">
							<?php esc_html_e('Don\'t Like It', 'magic-elementor'); ?>
							<i class="dashicons dashicons-star-empty"></i>
						</button>
					</div>

				</div>

			</div>
		</div>

	<?php
	}


	/**
	 * Pro addons info
	 *
	 * @param string $location The location.
	 */
	public function proaddon_info()
	{
		global $pagenow;

		$mge_proinfo = get_option('magical_pro_info_text');

		if ($mge_proinfo || 'themes.php' === $pagenow) {
			return;
		}

	?>
		<div class="mgele-notice notice notice-success mgadin-theme-dashboard mgadin-theme-dashboard-notice mge is-dismissible">
			<div class="mgadin-hero">
				<div class="mge-info-content mge-info-rev">
					<div class="mge-info-hello">
						<?php
						esc_html_e('Hi , ', 'magic-elementor');
						$current_user = wp_get_current_user();
						$prolink_one = 'https://wpthemespace.com/product/magical-addons-pro/?add-to-cart=7189';
						$prolink_two = 'https://magic.wpcolors.net/pricing-plan/#mgpricing';

						echo esc_html($current_user->display_name);
						?>

						<?php esc_html_e('👋🏻', 'magic-elementor'); ?>
					</div>

					<div class="mge-info-rev-item">
						<strong><?php esc_html_e('Now you can easily create an impressive website without coding knowledge with Magical Addons Pro !!', 'magic-elementor'); ?></strong>
					</div>
					<div class="mge-info-desc">
						<strong> <?php esc_html_e('Magical Addons Pro provides a fast and easy way to create and manage a professional website. With just a few clicks, users can select from a variety of ready-made pro website templates, customize the look and feel of the site. This powerful tool allows even the most technically inexperienced to craft an impressive website with no coding knowledge. So why late? Buy pro addon now ', 'magic-elementor'); ?>
						</strong>
					</div>
					<div class="mge-info-actions mgerev-action">
						<a href="<?php echo esc_url($prolink_one); ?>" target="_blank" class="button button-primary">
							<?php esc_html_e('Buy Pro Only $21', 'magic-elementor'); ?>
							<i class="dashicons dashicons-star-filled"></i>
						</a>
						<a href="<?php echo esc_url($prolink_two); ?>" target="_blank" class="button button-primary">
							<?php esc_html_e('View All Pring Plan', 'magic-elementor'); ?>
						</a>
						<button class="button mgpro-hide">
							<?php esc_html_e('No Need Pro', 'magic-elementor'); ?>
						</button>
					</div>

				</div>

			</div>
		</div>

	<?php
	}

	/**
	 * Add documentation page to admin menu
	 */
	public function add_documentation_page()
	{
		add_theme_page(
			__('Magic Elementor Documentation', 'magic-elementor'),
			__('Theme Documentation', 'magic-elementor'),
			'manage_options',
			'magic-elementor-documentation',
			array($this, 'documentation_page_content')
		);
	}

	/**
	 * Documentation page content
	 */
	public function documentation_page_content()
	{
	?>

		<div class="wrap magic-elementor-documentation">
			<h1></h1>
			<div class="mge-doc-header">
				<h1><?php esc_html_e('Magic Elementor Documentation', 'magic-elementor'); ?></h1>
				<p><?php esc_html_e('Complete guide to customize and use Magic Elementor theme', 'magic-elementor'); ?></p>
			</div>

			<div class="mge-doc-grid">
				<div class="mge-doc-content">
					<!-- Getting Started Section -->
					<div class="mge-doc-section" id="getting-started">
						<h2><span class="dashicons dashicons-star-filled"></span> <?php esc_html_e('Getting Started', 'magic-elementor'); ?></h2>
						<p><?php esc_html_e('Welcome to Magic Elementor! This modern, lightweight WordPress theme is specifically designed for Elementor page builder with full-site editing capabilities.', 'magic-elementor'); ?></p>

						<h3><?php esc_html_e('Theme Requirements', 'magic-elementor'); ?></h3>
						<ul>
							<li><?php esc_html_e('WordPress 6.0 or higher', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('PHP 7.4 or higher', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Elementor Plugin (recommended)', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('WooCommerce (optional)', 'magic-elementor'); ?></li>
						</ul>

						<h3><?php esc_html_e('First Steps', 'magic-elementor'); ?></h3>
						<ol>
							<li><?php esc_html_e('Install and activate the theme', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Install Elementor plugin', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Visit Appearance > Customize to configure basic settings', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Start building with Elementor!', 'magic-elementor'); ?></li>
						</ol>
					</div>

					<!-- Theme Features Section -->
					<div class="mge-doc-section" id="theme-features">
						<h2><span class="dashicons dashicons-admin-tools"></span> <?php esc_html_e('Theme Features', 'magic-elementor'); ?></h2>

						<h3><?php esc_html_e('Modern WordPress Features', 'magic-elementor'); ?></h3>
						<ul>
							<li><?php esc_html_e('Full Site Editing with theme.json support', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Block editor (Gutenberg) optimization', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Custom spacing, line height, and units support', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Wide and full alignment support', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Responsive embeds', 'magic-elementor'); ?></li>
						</ul>

						<h3><?php esc_html_e('Elementor Integration', 'magic-elementor'); ?></h3>
						<ul>
							<li><?php esc_html_e('Theme builder location registration', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Custom header and footer templates', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Hide page title option', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Seamless Elementor widget styling', 'magic-elementor'); ?></li>
						</ul>

						<h3><?php esc_html_e('WooCommerce Support', 'magic-elementor'); ?></h3>
						<ul>
							<li><?php esc_html_e('Product gallery with zoom, lightbox, and slider', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Optimized checkout and cart pages', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Mobile-responsive shop layouts', 'magic-elementor'); ?></li>
						</ul>
					</div>

					<!-- Customization Section -->
					<div class="mge-doc-section" id="customization">
						<h2><span class="dashicons dashicons-admin-customizer"></span> <?php esc_html_e('Customization', 'magic-elementor'); ?></h2>

						<h3><?php esc_html_e('WordPress Customizer', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('Access theme options through Appearance > Customize:', 'magic-elementor'); ?></p>
						<ul>
							<li><?php esc_html_e('Site Identity (logo, title, tagline)', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Colors and typography', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Header and footer settings', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Layout options', 'magic-elementor'); ?></li>
						</ul>

						<h3><?php esc_html_e('theme.json Configuration', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('Magic Elementor uses theme.json for modern styling. You can customize:', 'magic-elementor'); ?></p>
						<div class="mge-code">
							{<br>
							&nbsp;&nbsp;"settings": {<br>
							&nbsp;&nbsp;&nbsp;&nbsp;"color": {<br>
							&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"palette": [ /* Custom colors */ ]<br>
							&nbsp;&nbsp;&nbsp;&nbsp;},<br>
							&nbsp;&nbsp;&nbsp;&nbsp;"typography": {<br>
							&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;"fontFamilies": [ /* Custom fonts */ ]<br>
							&nbsp;&nbsp;&nbsp;&nbsp;}<br>
							&nbsp;&nbsp;}<br>
							}
						</div>

						<div class="mge-highlight">
							<strong><?php esc_html_e('Pro Tip:', 'magic-elementor'); ?></strong> <?php esc_html_e('Use a child theme when making custom modifications to preserve your changes during theme updates.', 'magic-elementor'); ?>
						</div>
					</div>

					<!-- Header & Footer Section -->
					<div class="mge-doc-section" id="header-footer">
						<h2><span class="dashicons dashicons-schedule"></span> <?php esc_html_e('Header & Footer Builder', 'magic-elementor'); ?></h2>

						<h3><?php esc_html_e('Using Elementor for Headers', 'magic-elementor'); ?></h3>
						<ol>
							<li><?php esc_html_e('Go to Templates > Theme Builder in Elementor', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Create a new Header template', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Design your header with Elementor widgets', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Set display conditions', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Publish and activate', 'magic-elementor'); ?></li>
						</ol>

						<h3><?php esc_html_e('Default Header/Footer', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('If you prefer the default header/footer, you can customize them through:', 'magic-elementor'); ?></p>
						<ul>
							<li><?php esc_html_e('Appearance > Customize > Header Settings', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Appearance > Menus for navigation', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Appearance > Widgets for footer content', 'magic-elementor'); ?></li>
						</ul>
					</div>

					<!-- Plugin Installation Section -->
					<div class="mge-doc-section" id="plugin-installation">
						<h2><span class="dashicons dashicons-admin-plugins"></span> <?php esc_html_e('Plugin Installation & Management', 'magic-elementor'); ?></h2>

						<h3><?php esc_html_e('TGM Plugin Activation', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('Magic Elementor includes TGM Plugin Activation to help you install required and recommended plugins easily.', 'magic-elementor'); ?></p>

						<h4><?php esc_html_e('Installing Recommended Plugins', 'magic-elementor'); ?></h4>
						<ol>
							<li><?php esc_html_e('After activating the theme, you\'ll see a notice at the top of your admin dashboard', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Click "Begin installing plugins" in the notice', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Select the plugins you want to install', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Click "Install" to automatically download and activate plugins', 'magic-elementor'); ?></li>
						</ol>

						<h4><?php esc_html_e('Recommended Plugins', 'magic-elementor'); ?></h4>
						<ul>
							<li><strong><?php esc_html_e('Elementor Page Builder', 'magic-elementor'); ?></strong> - <?php esc_html_e('Required for full theme functionality', 'magic-elementor'); ?></li>
							<li><strong><?php esc_html_e('Magical Addons for Elementor', 'magic-elementor'); ?></strong> - <?php esc_html_e('Additional widgets and features', 'magic-elementor'); ?></li>
							<li><strong><?php esc_html_e('Contact Form 7', 'magic-elementor'); ?></strong> - <?php esc_html_e('Contact form functionality', 'magic-elementor'); ?></li>
							<li><strong><?php esc_html_e('WooCommerce', 'magic-elementor'); ?></strong> - <?php esc_html_e('E-commerce functionality (optional)', 'magic-elementor'); ?></li>
						</ul>

						<div class="mge-highlight">
							<strong><?php esc_html_e('Tip:', 'magic-elementor'); ?></strong> <?php esc_html_e('You can always manage plugins later through Appearance > Install Plugins or the WordPress Plugins page.', 'magic-elementor'); ?>
						</div>

						<h3><?php esc_html_e('Manual Plugin Installation', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('If you prefer to install plugins manually:', 'magic-elementor'); ?></p>
						<ol>
							<li><?php esc_html_e('Go to Plugins > Add New in your WordPress admin', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Search for the plugin name', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Click "Install Now" and then "Activate"', 'magic-elementor'); ?></li>
						</ol>
					</div>

					<!-- Elementor Advanced Section -->
					<div class="mge-doc-section" id="elementor-advanced">
						<h2><span class="dashicons dashicons-admin-customizer"></span> <?php esc_html_e('Advanced Elementor Usage', 'magic-elementor'); ?></h2>

						<h3><?php esc_html_e('Theme Builder Locations', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('Magic Elementor supports all Elementor Pro theme builder locations:', 'magic-elementor'); ?></p>
						<ul>
							<li><strong><?php esc_html_e('Header', 'magic-elementor'); ?></strong> - <?php esc_html_e('Site-wide or conditional headers', 'magic-elementor'); ?></li>
							<li><strong><?php esc_html_e('Footer', 'magic-elementor'); ?></strong> - <?php esc_html_e('Site-wide or conditional footers', 'magic-elementor'); ?></li>
							<li><strong><?php esc_html_e('Single Post', 'magic-elementor'); ?></strong> - <?php esc_html_e('Custom post templates', 'magic-elementor'); ?></li>
							<li><strong><?php esc_html_e('Archive', 'magic-elementor'); ?></strong> - <?php esc_html_e('Custom archive layouts', 'magic-elementor'); ?></li>
							<li><strong><?php esc_html_e('404 Page', 'magic-elementor'); ?></strong> - <?php esc_html_e('Custom error pages', 'magic-elementor'); ?></li>
						</ul>

						<h3><?php esc_html_e('Creating Custom Headers with Elementor', 'magic-elementor'); ?></h3>
						<ol>
							<li><?php esc_html_e('Go to Templates > Theme Builder > Add New', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Choose "Header" as the template type', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Design your header using these widgets:', 'magic-elementor'); ?>
								<ul style="margin-top: 10px;">
									<li><?php esc_html_e('Site Logo widget for your logo', 'magic-elementor'); ?></li>
									<li><?php esc_html_e('Nav Menu widget for navigation', 'magic-elementor'); ?></li>
									<li><?php esc_html_e('Search widget for search functionality', 'magic-elementor'); ?></li>
									<li><?php esc_html_e('Social Icons widget for social links', 'magic-elementor'); ?></li>
									<li><?php esc_html_e('Button widget for call-to-action', 'magic-elementor'); ?></li>
								</ul>
							</li>
							<li><?php esc_html_e('Set display conditions (entire site, specific pages, etc.)', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Save and publish your header template', 'magic-elementor'); ?></li>
						</ol>

						<h3><?php esc_html_e('Creating Custom Footers with Elementor', 'magic-elementor'); ?></h3>
						<ol>
							<li><?php esc_html_e('Go to Templates > Theme Builder > Add New', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Choose "Footer" as the template type', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Use a multi-column layout for footer sections', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Add useful widgets:', 'magic-elementor'); ?>
								<ul style="margin-top: 10px;">
									<li><?php esc_html_e('Text Editor for company information', 'magic-elementor'); ?></li>
									<li><?php esc_html_e('Contact Info widget for address/phone', 'magic-elementor'); ?></li>
									<li><?php esc_html_e('Social Icons for social media links', 'magic-elementor'); ?></li>
									<li><?php esc_html_e('Copyright widget for copyright text', 'magic-elementor'); ?></li>
									<li><?php esc_html_e('Menu Anchor for footer navigation', 'magic-elementor'); ?></li>
								</ul>
							</li>
							<li><?php esc_html_e('Configure display conditions and publish', 'magic-elementor'); ?></li>
						</ol>

						<div class="mge-code">
							<?php esc_html_e('Pro Tip: Use Elementor\'s Motion Effects to add scroll animations to your headers and footers for a modern, engaging user experience.', 'magic-elementor'); ?>
						</div>

						<h3><?php esc_html_e('Theme Settings Integration', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('Magic Elementor provides seamless integration with Elementor:', 'magic-elementor'); ?></p>
						<ul>
							<li><?php esc_html_e('Automatic header/footer switching based on Elementor templates', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Page title hiding when using custom Elementor layouts', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Full-width container support for Elementor sections', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Compatible with Elementor\'s global colors and fonts', 'magic-elementor'); ?></li>
						</ul>

						<h3><?php esc_html_e('Working with Magical Addons', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('When you install Magical Addons for Elementor, you get access to:', 'magic-elementor'); ?></p>
						<ul>
							<li><?php esc_html_e('50+ additional Elementor widgets', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Pre-designed templates and blocks', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Advanced styling options', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('WooCommerce specific widgets', 'magic-elementor'); ?></li>
						</ul>

						<div class="mge-warning">
							<strong><?php esc_html_e('Important:', 'magic-elementor'); ?></strong> <?php esc_html_e('Always backup your site before making major changes to headers, footers, or templates.', 'magic-elementor'); ?>
						</div>
					</div>

					<!-- WooCommerce Integration Section -->
					<div class="mge-doc-section" id="woocommerce-integration">
						<h2><span class="dashicons dashicons-cart"></span> <?php esc_html_e('WooCommerce Integration', 'magic-elementor'); ?></h2>

						<h3><?php esc_html_e('Setting Up WooCommerce', 'magic-elementor'); ?></h3>
						<ol>
							<li><?php esc_html_e('Install and activate WooCommerce plugin', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Run the WooCommerce setup wizard', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Magic Elementor will automatically enable WooCommerce support', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Customize your shop layout using Elementor Pro', 'magic-elementor'); ?></li>
						</ol>

						<h3><?php esc_html_e('WooCommerce Features Included', 'magic-elementor'); ?></h3>
						<ul>
							<li><?php esc_html_e('Product gallery with zoom, lightbox, and slider', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Responsive shop and product layouts', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Cart and checkout page optimization', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Product quick view support', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('WooCommerce widgets compatibility', 'magic-elementor'); ?></li>
						</ul>

						<h3><?php esc_html_e('Customizing WooCommerce with Elementor', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('With Elementor Pro, you can create custom:', 'magic-elementor'); ?></p>
						<ul>
							<li><?php esc_html_e('Shop pages using Archive templates', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Product pages using Single Product templates', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Cart and checkout pages', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('My Account pages', 'magic-elementor'); ?></li>
						</ul>
					</div>

					<!-- Performance Section -->
					<div class="mge-doc-section" id="performance">
						<h2><span class="dashicons dashicons-performance"></span> <?php esc_html_e('Performance Optimization', 'magic-elementor'); ?></h2>

						<h3><?php esc_html_e('Built-in Optimizations', 'magic-elementor'); ?></h3>
						<ul>
							<li><?php esc_html_e('Google Fonts API v2 with font-display: swap', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Optimized CSS loading', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Minimal JavaScript footprint', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Responsive images support', 'magic-elementor'); ?></li>
						</ul>

						<h3><?php esc_html_e('Recommended Plugins', 'magic-elementor'); ?></h3>
						<ul>
							<li><?php esc_html_e('Caching plugin (WP Rocket, W3 Total Cache)', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Image optimization (Smush, ShortPixel)', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('CDN service (Cloudflare, MaxCDN)', 'magic-elementor'); ?></li>
						</ul>

						<div class="mge-warning">
							<strong><?php esc_html_e('Note:', 'magic-elementor'); ?></strong> <?php esc_html_e('Always test performance optimizations on a staging site before applying to production.', 'magic-elementor'); ?>
						</div>
					</div>

					<!-- Troubleshooting Section -->
					<div class="mge-doc-section" id="troubleshooting">
						<h2><span class="dashicons dashicons-sos"></span> <?php esc_html_e('Troubleshooting', 'magic-elementor'); ?></h2>

						<h3><?php esc_html_e('Common Issues', 'magic-elementor'); ?></h3>

						<h4><?php esc_html_e('Elementor not loading properly', 'magic-elementor'); ?></h4>
						<ul>
							<li><?php esc_html_e('Check if Elementor plugin is active', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Clear all caches', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Check PHP memory limit (minimum 256MB)', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Deactivate conflicting plugins', 'magic-elementor'); ?></li>
						</ul>

						<h4><?php esc_html_e('Theme not displaying correctly', 'magic-elementor'); ?></h4>
						<ul>
							<li><?php esc_html_e('Clear browser cache', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Regenerate CSS in Elementor > Tools', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Check for plugin conflicts', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Verify WordPress and theme versions', 'magic-elementor'); ?></li>
						</ul>

						<h3><?php esc_html_e('Getting Support', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('If you need help, please provide:', 'magic-elementor'); ?></p>
						<ul>
							<li><?php esc_html_e('WordPress version', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Theme version', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Active plugins list', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Error messages (if any)', 'magic-elementor'); ?></li>
							<li><?php esc_html_e('Steps to reproduce the issue', 'magic-elementor'); ?></li>
						</ul>
					</div>

				</div>

				<div class="mge-doc-sidebar">
					<!-- Pro Banner -->
					<div class="mge-pro-banner">
						<h3><?php esc_html_e('🚀 Magical Addons Pro', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('Supercharge your website with 50+ premium Elementor widgets and templates!', 'magic-elementor'); ?></p>
						<a href="https://wpthemespace.com/product/magical-addons-pro/" target="_blank" class="button">
							<?php esc_html_e('Get Pro for $21', 'magic-elementor'); ?>
						</a>
					</div>


					<!-- Table of Contents -->
					<div class="mge-toc">
						<h3><?php esc_html_e('Table of Contents', 'magic-elementor'); ?></h3>
						<ul>
							<li><a href="#getting-started"><?php esc_html_e('Getting Started', 'magic-elementor'); ?></a></li>
							<li><a href="#theme-features"><?php esc_html_e('Theme Features', 'magic-elementor'); ?></a></li>
							<li><a href="#customization"><?php esc_html_e('Customization', 'magic-elementor'); ?></a></li>
							<li><a href="#header-footer"><?php esc_html_e('Header & Footer Builder', 'magic-elementor'); ?></a></li>
							<li><a href="#plugin-installation"><?php esc_html_e('Plugin Installation', 'magic-elementor'); ?></a></li>
							<li><a href="#elementor-advanced"><?php esc_html_e('Advanced Elementor', 'magic-elementor'); ?></a></li>
							<li><a href="#woocommerce-integration"><?php esc_html_e('WooCommerce Integration', 'magic-elementor'); ?></a></li>
							<li><a href="#performance"><?php esc_html_e('Performance', 'magic-elementor'); ?></a></li>
							<li><a href="#troubleshooting"><?php esc_html_e('Troubleshooting', 'magic-elementor'); ?></a></li>
						</ul>
					</div>
					<!-- Posts Display Pro Banner -->
					<div class="mge-posts-banner">
						<h3><?php esc_html_e('📝 Magical Posts Display Pro', 'magic-elementor'); ?></h3>
						<p><?php esc_html_e('Create stunning post layouts, grids, sliders and carousels with advanced filtering!', 'magic-elementor'); ?></p>
						<a href="https://wpthemespace.com/product/magical-posts-display-pro/?add-to-cart=8239" target="_blank" class="button">
							<?php esc_html_e('Get Pro for $21', 'magic-elementor'); ?>
						</a>
					</div>
					<!-- Quick Links -->
					<div class="mge-info-box">
						<h3><?php esc_html_e('Quick Links', 'magic-elementor'); ?></h3>
						<p>
							<a href="https://www.youtube.com/watch?v=jTEckmVe9dE" target="_blank">
								<span class="dashicons dashicons-video-alt3"></span> <?php esc_html_e('Video Tutorial', 'magic-elementor'); ?>
							</a>
						</p>
						<p>
							<a href="https://wordpress.org/support/" target="_blank">
								<span class="dashicons dashicons-sos"></span> <?php esc_html_e('WordPress Support', 'magic-elementor'); ?>
							</a>
						</p>
						<p>
							<a href="https://elementor.com/help/" target="_blank">
								<span class="dashicons dashicons-external"></span> <?php esc_html_e('Elementor Help', 'magic-elementor'); ?>
							</a>
						</p>
					</div>

					<!-- Theme Info -->
					<div class="mge-info-box">
						<h3><?php esc_html_e('Theme Information', 'magic-elementor'); ?></h3>
						<p><strong><?php esc_html_e('Version:', 'magic-elementor'); ?></strong> <?php echo esc_html(MAGIC_ELEMENTOR_VERSION); ?></p>
						<p><strong><?php esc_html_e('Author:', 'magic-elementor'); ?></strong> Noor Alam</p>
						<p><strong><?php esc_html_e('License:', 'magic-elementor'); ?></strong> GPL v2+</p>
					</div>
				</div>
			</div>
		</div>
<?php
	}

	/*
	/*
	*
	* Admin info style and scripts
	*
	*/
	public function admin_info_assets()
	{
		$ajax_url = admin_url('admin-ajax.php');
		$nonce = wp_create_nonce('dismissopenot');
		$nonce_rev = wp_create_nonce('dismissrev');

		wp_enqueue_style('magic-elementor-admininfo-style', get_template_directory_uri() . '/assets/css/admin-info.css', array(), MAGIC_ELEMENTOR_VERSION);

		// Enqueue documentation page styles only on the documentation page
		$current_screen = get_current_screen();
		if ($current_screen && $current_screen->id === 'appearance_page_magic-elementor-documentation') {
			wp_enqueue_style('magic-elementor-admin-documentation', get_template_directory_uri() . '/assets/css/admin-documentation.css', array(), MAGIC_ELEMENTOR_VERSION);
		}

		wp_enqueue_script('magic-elementor-admininfo-scripts', get_template_directory_uri() . '/assets/js/admin-info.js', array(), MAGIC_ELEMENTOR_VERSION, true);
		wp_localize_script('magic-elementor-admininfo-scripts', 'mgelajinfo', ['ajax_url' => $ajax_url, 'nonce' => $nonce]);
	}

	public function welcome_video_infohide()
	{
		if (check_ajax_referer('dismissopenot', 'nonce')) {
			if (isset($_POST['dismiss']) && $_POST['dismiss'] == 1) {
				update_option('mge-admin-winfo1', 1);
				wp_die('done');
			}
		}
		if (check_ajax_referer('dismissopenot', 'nonce')) {
			if (isset($_POST['revdismiss']) && $_POST['revdismiss'] == 1) {
				update_option('mge_admin_reve4', 1);
				wp_die('done');
			}
		}
		if (check_ajax_referer('dismissopenot', 'nonce')) {
			if (isset($_POST['prodismiss']) && $_POST['prodismiss'] == 1) {
				update_option('magical_pro_info_text', 1);
				wp_die('done');
			}
		}
	}
}

new magicElementorUserInfo();
