<?php
/*This file is part of magever, newsever child theme.

All functions of this file will be loaded before of parent theme functions.
Learn more at https://codex.wordpress.org/Child_Themes.

Note: this function loads the parent stylesheet before, then child theme stylesheet
(leave it in place unless you know what you are doing.)
*/

if (!function_exists('magever_locale_css')):
    function magever_locale_css($uri)
    {
        if (empty($uri) && is_rtl() && file_exists(get_template_directory() . '/rtl.css'))
            $uri = get_template_directory_uri() . '/rtl.css';
        return $uri;
    }
endif;

add_filter('locale_stylesheet_uri', 'magever_locale_css');


if ( ! function_exists( 'magever_child_enqueue_child_styles' ) ) {
	function magever_enqueue_child_styles() {
	    $min = defined('SCRIPT_DEBUG') && SCRIPT_DEBUG ? '' : '.min';
        $parent_style = 'newsever-style';
        wp_enqueue_style('sidr', get_template_directory_uri() . '/assets/sidr/css/jquery.sidr.dark.css');
        wp_enqueue_style('bootstrap', get_template_directory_uri() . '/assets/bootstrap/css/bootstrap' . $min . '.css');
        wp_enqueue_style($parent_style, get_template_directory_uri() . '/style.css' );
        wp_enqueue_style(
            'magever',
            get_stylesheet_directory_uri() . '/style.css',
            array( 'bootstrap', $parent_style ),
            wp_get_theme()->get('Version') );
	 }
}
add_action( 'wp_enqueue_scripts', 'magever_enqueue_child_styles' );

/*Write here your own functions */

if( ! function_exists('magever_filter_default_theme_options')){
    function magever_filter_default_theme_options($defaults){
        $defaults['global_site_mode_setting'] = 'aft-light-mode';
        $defaults['frontpage_content_alignment'] = 'frontpage-layout-2';
        return $defaults;
    }
}

add_filter('newsever_filter_default_theme_options', 'magever_filter_default_theme_options', 10, 1);