<?php
/**
 * header.php - Doctype/Title/Meta/CSS/Feeds
 *
 * Fsk141 Framework
 * Unbloated template for simpletons
 *
 * License GPLv3 (license.txt)
 */
?>

<!DOCTYPE html>

<!-- START Everything -->

<html xmlns="http://www.w3.org/1999/xhtml" <?php language_attributes( 'xhtml' ); ?>>

<!-- START Head -->
<head> 

	<!-- Meta -->
	<meta http-equiv="Content-Type" content="<?php bloginfo( 'html_type' ); ?>; charset=<?php bloginfo('charset'); ?>" />

	<!-- Title -->
	<title> <?php bloginfo('name'); echo " "; bloginfo('description'); wp_title('|'); ?> </title>

	<!-- Favicon -->
	<?php /* <link rel="shortcut icon" href="<?php echo get_template_directory_uri(); ?>/stash/images/favicon.ico" /> */ ?>

	<!-- Stylesheet -->
	<!-- <link rel="stylesheet" href="http://meyerweb.com/eric/tools/css/reset/reset.css" type="text/css" media="screen, projection" /> -->
	<link rel="stylesheet" href="<?php bloginfo( 'stylesheet_url' ); ?>" type="text/css" media="screen, projection" />

	<!-- comment-reply -->
	<?php if ( is_singular() && get_option( 'thread_comments' ) ) wp_enqueue_script( 'comment-reply' ); ?>
	
	<!-- Feeds are automatically handled with add_theme_support('automatic-feed-links'); in stash/functions/core.php -->	

	<!-- HTML5 IE compatibility -->
        <!--[if lt IE 9]>
                <script src="<?php echo get_template_directory_uri(); ?>/stash/js/html5.js"></script>
        <![endif]-->

	<?php wp_head(); ?>

<!-- STOP Head -->
</head>
