<?php
/**
 * comments.php - comments template
 *
 * Fsk141 Framework
 * Unbloated template for simpletons
 *
 * License GPLv3 (license.txt)
 */
?>

<?php
if (!empty($_SERVER['SCRIPT_FILENAME']) && 'comments.php' == basename($_SERVER['SCRIPT_FILENAME']))
	die ('Please do not load this page directly. Thanks!');
if ( post_password_required() ) {
	echo '<p class="nocomments">This post is password protected. Enter the password to view comments.</p>';
	return;
}
?>

<?php
if ( have_comments() ) : ?>
<h4 id="comments"><?php comments_number('No Comments', 'One Comment', '% Comments' );?></h4>
<ul class="commentlist">
	<?php wp_list_comments(); ?></ul>
<div class="navigation">
<div class="alignleft"><?php previous_comments_link() ?></div>
<div class="alignright"><?php next_comments_link() ?></div>
</div>
<?php else : // this is displayed if there are no comments so far ?>

<?php if ( comments_open() ) : // If comments are open, but there are no comments ?>

<?php else : // or, if we don't have comments:

	/* If there are no comments and comments are closed,
	* 	 * let's leave a little note, shall we?
	* 	 	 * But only on posts! We don't want the note on pages.
	* 	 	 	 */
	if ( ! comments_open() && ! is_page() ) :
			?>
	<p class="nocomments"><?php _e( 'Comments are closed.', 'YOUR_DOMAIN_NAME' ); ?></p>
	<?php endif; ?>

<?php endif; ?>

<?php
endif;
	comment_form();
?>
