<?php 
/**
 * Template part for displaying Services Section
 *
 *@package Kids Education Bell Pro

 */

    $team_title       = junior_education_get_option( 'team_title' );
    $team_subtitle       = junior_education_get_option( 'team_subtitle' );
    $number_of_column = junior_education_get_option( 'number_of_column' );
    $number_of_items  = junior_education_get_option( 'number_of_team_items' );
    $team_content_type     = junior_education_get_option( 'team_content_type' );
    $team_category = junior_education_get_option( 'team_category' );
    $team_content   = junior_education_get_option( 'team_content_enable' );
    $team_header_font_size = junior_education_get_option( 'team_font_size');
    $team_content_font_size = junior_education_get_option( 'team_content_font_size');
    $team_subtitle_font_size = junior_education_get_option( 'team_subtitle_font_size');
    $team_section_header_font_size = junior_education_get_option( 'team_section_header_font_size');
    $home_layout = junior_education_get_option( 'homepage_design_layout_options');

    for( $i=1; $i<=$number_of_items; $i++ ) :
        $team_page_posts[] = absint(junior_education_get_option( 'team_page_'.$i ) );
        $team_post_posts[] = absint(junior_education_get_option( 'team_post_'.$i ) );
        $team_position     = junior_education_get_option( 'team_custom_position_'. $i );
    endfor;
    ?>
    <style>
        <?php if ($team_subtitle_font_size != 0): ?>
            #team .section-subtitle{
                font-size:<?php echo esc_html($team_subtitle_font_size); ?>px;
            }
        <?php endif ?>
        <?php if ($team_section_header_font_size != 0): ?>
            #team .section-title{
                font-size:<?php echo esc_html($team_section_header_font_size); ?>px;
            }
        <?php endif ?>

        <?php if ($team_header_font_size != 0): ?>
            #team .entry-title a{
                font-size:<?php echo esc_html($team_header_font_size); ?>px;
            }
        <?php endif ?>
        <?php if ($team_content_font_size != 0): ?>
            #team .entry-content p{
                font-size:<?php echo esc_html($team_content_font_size); ?>px;
            }
        <?php endif ?>
    </style>
    <div class=" team-section relative">
        <?php if (!empty($team_title) || !empty($team_subtitle)) : ?>
            
            <div class="section-header">
             <?php if(!empty($team_title)):?>
                <h2 class="section-title"><?php echo esc_html($team_title); ?></h2>                                  
            <?php endif;  ?>
            <?php if (!empty($team_subtitle)): ?>
                <p class="section-subtitle"><?php echo esc_html($team_subtitle);?></p>
            <?php endif; ?>
            </div><!-- .section-header -->
        <?php endif;       
        ?>
                        
        <div class="section-content col-<?php echo esc_attr($number_of_column); ?>">
            <?php
                $args = array (
                    'post_type'     => 'post',
                    'post_per_page' => count( $team_post_posts ),
                    'post__in'      => $team_post_posts,
                    'orderby'       =>'post__in', 
                    'ignore_sticky_posts' => true, 
                ); 
                $loop = new WP_Query($args);                         
                if ( $loop->have_posts() ) :
                    $i=0;  
                    while ($loop->have_posts()) : $loop->the_post(); $i++;?>
                        <?php $team_post_bg_color = junior_education_get_option( 'team_member_background_color_'.$i ); ?>
                        <article class="hentry <?php if ($home_layout =='home-corporate') { ?>  grid-item <?php } ?> ">
                            <div class="post-wrapper" style=" background-color: <?php echo esc_attr($team_post_bg_color) ?>">
                                <div class="featured-image">
                                     <a href="<?php the_permalink(); ?>"><img class="team-image" src="<?php the_post_thumbnail_url('kids-education-bell-team');?>"> </a>
                                    <!-- <div class="overlay"></div> -->
                                </div><!-- .team-image -->                                   
                                <div class="entry-container">
                                    <header class="entry-header">
                                        <h2 class="entry-title">
                                            <a href="<?php the_permalink(); ?>">
                                                <?php the_title(); ?>
                                            </a>
                                        </h2>
                                    </header>
                                   <?php $team_position = junior_education_get_option( 'team_custom_position_'. $i ); ?>
                                    <?php if ( !empty($team_position) ) : ?>
                                        <h6 class="position"><?php echo esc_html( $team_position ); ?></h6>
                                    <?php endif; ?>
                                    <?php if ($team_content == true): ?>
                                        <div class="entry-content">
                                            <?php
                                                $excerpt = kids_education_bell_the_excerpt( 10 );
                                                echo wp_kses_post( wpautop( $excerpt ) );
                                            ?>
                                        </div><!-- .entry-content -->
                                    <?php endif ?>
                                </div><!-- .entry-container -->
                            </div><!-- .post-wrapper -->
                        </article>
                        <?php endwhile;
                    endif;
                wp_reset_postdata(); ?>
        </div><!-- .section-content -->
    </div><!-- #team-posts -->
