<?php
/**
 * Team options.
 *
 * @package Junior Education 
 */

$default = junior_education_get_default_theme_options();
$homepage_design_layout     = junior_education_get_option( 'homepage_design_layout_options' );

// Team Author Section
$wp_customize->add_section( 'section_home_team',
	array(
		'title'      => __( 'Team Section', 'junior-education' ),
		'capability' => 'edit_theme_options',
		'panel'      => 'home_page_panel',
		'priority'   => 100,
		)
);

$wp_customize->add_setting( 'theme_options[disable_team_section]',
	array(
		'default'           => $default['disable_team_section'],
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',
		'sanitize_callback' => 'Kids_education_bell_sanitize_switch_control',
	)
);
$wp_customize->add_control( new Junior_Education_Switch_Control( $wp_customize, 'theme_options[disable_team_section]',
    array(
		'label' 			=> __('Enable/Disable Team Section', 'junior-education'),
		'section'    		=> 'section_home_team',
		 'settings'  		=> 'theme_options[disable_team_section]',
		'on_off_label' 		=> junior_education_switch_options(),
    )
) );
//Team Section title
$wp_customize->add_setting('theme_options[team_title]', 
	array(
	'default'           => $default['team_title'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_text_field'
	)
);

$wp_customize->add_control('theme_options[team_title]', 
	array(
	'label'       => __('Section Title', 'junior-education'),
	'section'     => 'section_home_team',   
	'settings'    => 'theme_options[team_title]',
	'active_callback' => 'kids_education_bell_team_active',		
	'type'        => 'text'
	)
);


//Project Section Subtitle
$wp_customize->add_setting('theme_options[team_subtitle]', 
	array(
	'default'           => $default['team_subtitle'],
	'type'              => 'theme_mod',
	'capability'        => 'edit_theme_options',	
	'sanitize_callback' => 'sanitize_textarea_field'
	)
);

$wp_customize->add_control('theme_options[team_subtitle]', 
	array(
	'label'       => __('Section Sub Title', 'junior-education'),
	'section'     => 'section_home_team',   
	'settings'    => 'theme_options[team_subtitle]',
	'active_callback' => 'kids_education_bell_team_active',		
	'type'        => 'textarea'
	)
);


// Add autoplay enable setting and control.
$wp_customize->add_setting( 'theme_options[team_content_enable]', array(
	'default'           => $default['team_content_enable'],
	'sanitize_callback' => 'kids_education_bell_sanitize_checkbox',
) );

$wp_customize->add_control( 'theme_options[team_content_enable]', array(
	'label'             => esc_html__( 'Enable Team Content', 'junior-education' ),
	'section'           => 'section_home_team',
	'type'              => 'checkbox',
	'active_callback' => 'kids_education_bell_team_active',
) );

$number_of_team_items = junior_education_get_option( 'number_of_team_items' );

for( $i=1; $i<=$number_of_team_items; $i++ ){

	//
	$wp_customize->add_setting('theme_options[team_post_'.$i.']', 
		array(
		'type'              => 'theme_mod',
		'capability'        => 'edit_theme_options',	
		'sanitize_callback' => 'Kids_education_bell_dropdown_pages'
		)
	);

	$wp_customize->add_control('theme_options[team_post_'.$i.']', 
		array(
		'label'       => sprintf( __('Select Post #%1$s', 'junior-education'), $i),
		'section'     => 'section_home_team',   
		'settings'    => 'theme_options[team_post_'.$i.']',		
		'type'        => 'select',
		'choices'	  => junior_education_post_choices(),
		'active_callback' => 'kids_education_bell_team_active',
		)
	);

	// team title setting and control
	$wp_customize->add_setting( 'theme_options[team_custom_position_' . $i . ']', array(
		'type'              => 'theme_mod',
		'sanitize_callback' => 'sanitize_text_field',
	) );

	$wp_customize->add_control( 'theme_options[team_custom_position_' . $i . ']', array(
		'label'           	=> sprintf( __( 'Position %d', 'junior-education' ), $i ),
		'section'        	=> 'section_home_team',
		'settings'    		=> 'theme_options[team_custom_position_'.$i.']',	
		'active_callback' 	=> 'kids_education_bell_team_active',
		'type'				=> 'text',
	) );
}

