<?php
/**
 * Template part for displaying hero content
 *
 * @package jalbee
 */


$hide_hero = get_theme_mod( 'show_hero', true );

if ( ! $hide_hero ) {
	return;
}

/*
* Include the component stylesheet for the content.
* This call runs only once on index and archive pages.
* At some point, override functionality should be built in similar to the template part below.
*/
	wp_print_styles( array( 'jalbee-hero' ) ); // Note: If this was already done it will be skipped.

// Get site name and description for default value.
$site_name        = get_bloginfo( 'name' );
$site_description = get_bloginfo( 'description' );

$hero_title       = get_theme_mod( 'hero_title', $site_name );
$hero_subtitle    = get_theme_mod( 'hero_subtitle', $site_description );
$hide_hero_text   = get_theme_mod( 'hero_hide_text' );
$hero_full_height = get_theme_mod( 'hero_full_height', true );
$hero_logo        = get_theme_mod( 'hero_logo' );
$hero_logo_retina = get_theme_mod( 'hero_logo_retina' );

$volume_up_icon_url = get_theme_file_uri( '/images/volume-up.svg' );
$mute_icon_url      = get_theme_file_uri( '/images/volume-mute.svg' );

$hero_background       = get_theme_mod( 'hero_background' );
$hero_video            = get_theme_mod( 'hero_video' );
$is_hero_video_muted   = get_theme_mod( 'hero_video_muted', true );
$is_show_volume_button = get_theme_mod( 'hero_video_show_volume_button' );

$is_hide_drop_down = get_theme_mod( 'hide_drop_down' );

?>

<section class="hero  <?php echo ( $hero_full_height ) ? 'hero-full-height' : ''; ?>" data-menu-position=<?php echo esc_attr( get_theme_mod( 'menu-position', true ) ); ?>>
	<?php
	if ( ! empty( $hero_background['background-image'] ) || ! empty( $hero_video ) ) :
		;
		?>
	<div class="hero-background" style="background-image:url(<?php echo ( ! empty( $hero_background['background-image'] ) ) ? esc_url( $hero_background['background-image'] ) : ''; ?>)">

		<?php
		if ( ! empty( $hero_video ) ) :
			;
			?>
			<video class="hero-video" loop autoplay <?php echo $is_hero_video_muted ? 'muted="true"' : ''; ?>>
				<source src="<?php echo esc_url( $hero_video ); ?>" type="video/<?php echo pathinfo( parse_url( $hero_video )['path'], PATHINFO_EXTENSION ) == 'mp4' ? 'mp4' : 'webm'; ?>">
			</video>
		<?php endif; // End of hero video. ?>
	</div>
	<?php endif; // end of background section. ?>
	<div class="hero-content">
		<div class="hero-image">
			<?php if ( $hero_logo ) { ?>
				<img class="retina" src="<?php echo esc_url( $hero_logo ); ?>"  data-fullsrc="<?php echo esc_url( $hero_logo_retina ); ?>">
			<?php } // end of hero logo. ?>
		</div>
		<?php
		if ( ! $hide_hero_text ) :
			;
			?>
		<h1 class="hero-title"><?php echo esc_html( $hero_title, 'jalbee' ); ?></h1>
		<p class="hero-subtitle"><?php echo esc_html( $hero_subtitle, 'jalbee' ); ?></p>
		<?php endif; // end of hide hero text. ?>
	</div>
	<?php
	if ( $is_show_volume_button && ! empty( $hero_video ) ) {
		?>
		<span class="volume-button button-mute "><img src="<?php echo $is_hero_video_muted ? esc_url( $mute_icon_url ) : esc_url( $volume_up_icon_url ); ?>" ></span>
		<?php
	}// end of show vlume button.
	?>
	<?php if ( ! $is_hide_drop_down ) : ?>
	<a href="#primary" class="move-content">
	<span class="arrow-down"><img src="<?php echo get_theme_file_uri( '/images/angle-down.svg' ); ?>" ></span>
	<a>
<?php endif; // hide drop down ?>
</section>

