<?php
/**
 * The sidebar containing the main widget area
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package jalbee
 */

$hide_sidebar = get_theme_mod( 'hide_sidebar' );

if ( ! is_active_sidebar( 'sidebar-1' ) || $hide_sidebar ) {
	return;
}

$hide_sidebar_page    = ( is_page() && get_theme_mod( 'hide_sidebar_page' ) );
$hide_sidebar_single  = ( is_single() && get_theme_mod( 'hide_sidebar_single' ) );
$hide_sidebar_archive = ( is_archive() && get_theme_mod( 'hide_sidebar_archive' ) );
$hide_sidebar_home    = ( is_home() && get_theme_mod( 'hide_sidebar_home', true ) );

if ( $hide_sidebar_page || $hide_sidebar_single || $hide_sidebar_archive || $hide_sidebar_home ) {
	return;
}



?>

<?php wp_print_styles( array( 'jalbee-sidebar', 'jalbee-widgets' ) ); ?>
<aside id="secondary" class="primary-sidebar widget-area">
	<?php dynamic_sidebar( 'sidebar-1' ); ?>
</aside><!-- #secondary -->
