'use strict';

jQuery.noConflict();
(function ($) {

	$(window).load(function () {
		// Get Image size and switch for retina if class of retina exists.
		$('img.retina').each(function () {
			var retinaImg = $(this),
			    retinaImgFull = retinaImg.attr('data-fullsrc');

			if (!retinaImgFull) {
				return false;
			}
			retinaImg.attr('width', retinaImg.width());
			retinaImg.attr('height', retinaImg.height());

			if (window.devicePixelRatio >= 1.5) {
				retinaImg.attr('src', retinaImgFull);
				retinaImg.attr('width', retinaImg.width());
				retinaImg.attr('height', retinaImg.height());
			}
		});
	});

	$(".volume-button").on('click', function (e) {
		e.preventDefault();
		if ($(".hero-video").prop('muted')) {
			$(".hero-video").prop('muted', false);
			$('.volume-button>img').attr('src', jalbee.volume_up_image);
		} else {
			$(".hero-video").prop('muted', true);
			$('.volume-button>img').attr('src', jalbee.volume_mute_image);
		}
	});

	$(".move-content").on('click', function (e) {
		event.preventDefault();
		var hash = this.hash;
		var scrollHeight = $(hash).offset().top - $('.site-header').height();

		$('html, body').animate({
			scrollTop: scrollHeight
		}, 800, function () {

			// Add hash (#) to URL when done scrolling (default click behavior)
			window.location.hash = hash;
		});
	});
})(jQuery);