<?php

/**
 * Register a meta box using a class.
 */
class Jalbee_Metabox {

	/**
	 * Constructor.
	 */
	public function __construct() {
		if ( is_admin() ) {
			add_action( 'load-post.php', array( $this, 'init_metabox' ) );
			add_action( 'load-post-new.php', array( $this, 'init_metabox' ) );
		}

	}

	/**
	 * Meta box initialization.
	 */
	public function init_metabox() {
		add_action( 'add_meta_boxes', array( $this, 'add_metabox' ) );
		add_action( 'save_post', array( $this, 'save_metabox' ), 10, 2 );
	}

	/**
	 * Adds the meta box.
	 */
	public function add_metabox() {
		add_meta_box(
			'my-meta-box',
			__( 'Side bar Position ( it will override customizer settings )', 'jalbee' ),
			array( $this, 'render_metabox' ),
			'post',
			'advanced',
			'default'
		);

	}

	/**
	 * Renders the meta box.
	 */
	public function render_metabox( $post ) {
		// Add nonce for security and authentication.
		wp_nonce_field( 'sidebar_position', 'jalbee_sidebar_position_nonce' );
		 // Use get_post_meta to retrieve an existing value from the database.
		 $value = get_post_meta( $post->ID, 'sidebar_position_field', true );
		 // Display the form, using the current value.
		?>
		 <div class="sidebar_meta_jalbee">
		 <style>
			.sidebar_meta_jalbee span{
			display: inline-block;
			min-width: 100px;
			}
		 </style>
		 <label for="sidebar_position_field">
			 <?php // _e( 'This setting will over ride the customizer setting', 'jalbee' ); ?> 
		 </label>
		 <span> <?php _e( 'Left side', 'jalbee' )?> </span><input type="radio" id="sidebar_position_field" name="sidebar_position_field" value="left_side" <?php checked( $value, 'left_side', true ); ?> size="25" /><br/>
		 <span> <?php _e( 'Right side', 'jalbee' )?> </span><input type="radio" id="sidebar_position_field" name="sidebar_position_field" value="right_side" <?php checked( $value, 'right_side', true ); ?> size="25" /><br/>
		 <span> <?php _e( 'None', 'jalbee' )?> </span><input type="radio" id="sidebar_position_field" name="sidebar_position_field" value="none" <?php checked( $value, 'none', true ); ?> size="25" />
		 </div>
		 <?php
	}

	/**
	 * Handles saving the meta box.
	 *
	 * @param int     $post_id Post ID.
	 * @param WP_Post $post    Post object.
	 * @return null
	 */
	public function save_metabox( $post_id, $post ) {
		// Add nonce for security and authentication.
		$nonce_name   = isset( $_POST['jalbee_sidebar_position_nonce'] ) ? $_POST['jalbee_sidebar_position_nonce'] : '';
		$nonce_action = 'sidebar_position';
		$sidebar_position_options = array( 'left_side', 'right_side', 'none' );
		// Check if nonce is valid.
		if ( ! wp_verify_nonce( $nonce_name, $nonce_action ) ) {
			return;
		}

		// Check if user has permissions to save data.
		if ( ! current_user_can( 'edit_post', $post_id ) ) {
			return;
		}

		// Check if not an autosave.
		if ( wp_is_post_autosave( $post_id ) ) {
			return;
		}

		// Check if not a revision.
		if ( wp_is_post_revision( $post_id ) ) {
			return;
		}

		// Sanitize and validate the user input.
		$field_data = sanitize_text_field( $_POST['sidebar_position_field'] );
		$data = in_array( $field_data, $sidebar_position_options ) ? $field_data : '';

		// Update the meta field.
		update_post_meta( $post_id, 'sidebar_position_field', $data );
	}
}

new Jalbee_Metabox();
