<?php
/**
 * Jalbee Sidebar Customizer
 *
 * @package jalbee
 */


Jalbee_Kirki::add_section( 'jalbee_layout_options', array(
	'title'          => esc_html__( 'Layout Settings', 'jalbee' ),
	'description'    => esc_html__( 'Customize layout according to your desire.', 'jalbee' ),
	'priority'       => 13,
) );

$layout_opinions = array(
	'sidebar_switch' => array(
		'default' => false,
		'label'   => esc_html__( 'Switch Sidebar to left', 'jalbee' )
	),
	'hide_sidebar' => array(
		'default' => false,
		'label'   => esc_html__( 'Hide the Sidebar (Everywhere)', 'jalbee' )
	),
	'hide_sidebar_page' => array(
		'default' => false,
		'label'   => esc_html__( 'Hide the Sidebar on just pages', 'jalbee' )
	),
	'hide_sidebar_single' => array(
		'default' => false,
		'label'   => esc_html__( 'Hide the Sidebar on posts', 'jalbee' )
	),
	'hide_sidebar_archive' => array(
		'default' => false,
		'label'   => esc_html__( 'Hide the Sidebar on just archive pages', 'jalbee' )
	),
	'hide_sidebar_home' => array(
		'default' => true,
		'label'   => esc_html__( 'Hide the Sidebar on just the homepage', 'jalbee' )
	),
);

foreach ($layout_opinions as $key => $value) {
	Jalbee_Kirki::add_field( 'jalbee', [
		'type'        => 'checkbox',
		'settings'    => $key,
		'label'       => $value['label'],
		'section'     => 'jalbee_layout_options',
		'sanitize_callback' => 'jalbee_sanitize_checkbox',
		'default'     => $value['default'],
	] );
}