<?php
/**
 * Jalbee Hero Customizer
 *
 * @package jalbee
 */

/**
 * Nav settings
 */

// Hero visibility section.
Jalbee_Kirki::add_section(
	'jalbee_nav_options',
	array(
		'title'       => esc_html__( 'Menu Position', 'jalbee' ),
		'description' => esc_html__( 'Customize nav according to your desired.', 'jalbee' ),
		'priority'    => 12,
	)
);

Jalbee_Kirki::add_field(
	'jalbee',
	[
		'type'              => 'checkbox',
		'settings'          => 'make-sticky-menu',
		'label'             => esc_html__( 'Make Menu Sticky', 'jalbee' ),
		'section'           => 'jalbee_nav_options',
		'sanitize_callback' => 'jalbee_sanitize_checkbox',
		'default'           => true,
	]
);

Jalbee_Kirki::add_field(
	'jalbee',
	[
		'type'              => 'select',
		'settings'          => 'menu-position',
		'label'             => esc_html__( 'Menu Position', 'jalbee' ),
		'section'           => 'jalbee_nav_options',
		'default'           => 'after-hero',
		'multiple'          => false,
		'sanitize_callback' => 'jalbee_sanitize_select',
		'choices'           => [
			'after-hero' => esc_html__( 'After Hero', 'jalbee' ),
			'top'        => esc_html__( 'Top', 'jalbee' ),
			'bottom'     => esc_html__( 'Bottom', 'jalbee' ),
		],
	]
);
