<?php
/**
 * Jalbee Hero Customizer
 *
 * @package jalbee
 */

// Get site name and description so we can populate fields below accordingly.
$site_name        = get_bloginfo( 'name' );
$site_description = get_bloginfo( 'description' );

Jalbee_Kirki::add_panel(
	'hero_panel',
	array(
		'priority' => 10,
		'title'    => esc_html__( 'Hero Section', 'jalbee' ),
	)
);

// Hero visibility section.
Jalbee_Kirki::add_section(
	'jalbee_hero_visibility_options',
	array(
		'title'       => esc_html__( 'Hero Visibility', 'jalbee' ),
		'panel'       => 'hero_panel',
		'description' => esc_html__( 'You can hide/show hero section.', 'jalbee' ),
		'priority'    => 10,
	)
);

Jalbee_Kirki::add_field(
	'jalbee',
	[
		'type'              => 'checkbox',
		'settings'          => 'show_hero',
		'label'             => esc_html__( 'Show Homepage Hero', 'jalbee' ),
		'tooltip'           => esc_html__( 'Is you want to show hero section yes/no', 'jalbee' ),
		'section'           => 'jalbee_hero_visibility_options',
		'sanitize_callback' => 'jalbee_sanitize_checkbox',
		'default'           => true,
	]
);

// Hero Text section.
Jalbee_Kirki::add_section(
	'jalbee_hero_text_options',
	array(
		'title'       => esc_html__( 'Hero Text', 'jalbee' ),
		'panel'       => 'hero_panel',
		'description' => esc_html__( 'You can customize hero text according to your desire.', 'jalbee' ),
		'priority'    => 20,
	)
);


Jalbee_Kirki::add_field(
	'jalbee',
	[
		'type'              => 'text',
		'settings'          => 'hero_title',
		'label'             => esc_html__( 'Hero Title', 'jalbee' ),
		'section'           => 'jalbee_hero_text_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => $site_name,
	]
);

Jalbee_Kirki::add_field(
	'jalbee',
	[
		'type'              => 'text',
		'settings'          => 'hero_subtitle',
		'label'             => esc_html__( 'Hero Sub Title', 'jalbee' ),
		'section'           => 'jalbee_hero_text_options',
		'sanitize_callback' => 'sanitize_text_field',
		'default'           => $site_description,
	]
);

Jalbee_Kirki::add_field(
	'jalbee',
	[
		'type'              => 'checkbox',
		'settings'          => 'hero_hide_text',
		'label'             => esc_html__( 'Hide Hero Text', 'jalbee' ),
		'section'           => 'jalbee_hero_text_options',
		'sanitize_callback' => 'jalbee_sanitize_checkbox',
		'default'           => false,
	]
);

// Hero Background section.
Jalbee_Kirki::add_section(
	'jalbee_hero_background_options',
	array(
		'title'       => esc_html__( 'Hero Background', 'jalbee' ),
		'panel'       => 'hero_panel',
		'description' => esc_html__( 'You can customize hero background according to your desire.', 'jalbee' ),
		'priority'    => 30,
	)
);

Jalbee_Kirki::add_field(
	'jalbee',
	[
		'type'      => 'background',
		'settings'  => 'hero_background',
		'label'     => esc_html__( 'Hero back Ground', 'jalbee' ),
		'section'   => 'jalbee_hero_background_options',
		'default'   => [
			'background-color'      => 'rgba(20,20,20,.8)',
			'background-image'      => '',
			'background-repeat'     => 'no-repeat',
			'background-position'   => 'center center',
			'background-size'       => 'cover',
			'background-attachment' => 'scroll',
		],
		'transport' => 'auto',
	]
);

Jalbee_Kirki::add_field(
	'jalbee',
	[
		'type'              => 'upload',
		'settings'          => 'hero_video',
		'label'             => esc_html__( 'Hero Video', 'jalbee' ),
		'section'           => 'jalbee_hero_background_options',
		'default'           => '',
		'sanitize_callback' => 'esc_url',
	]
);

$video_controls = array(
	'hero_video_show_volume_button' => array(
		'label'   => __( 'Show volume button', 'jalbee' ),
		'default' => true,
	),
	'hero_video_muted'              => array(
		'label'   => __( 'Mute Hero Video', 'jalbee' ),
		'default' => false,
	),
);

foreach ( $video_controls as $key => $value ) {
	Jalbee_Kirki::add_field(
		'jalbee',
		[
			'type'              => 'checkbox',
			'settings'          => $key,
			'label'             => $value['label'],
			'section'           => 'jalbee_hero_background_options',
			'sanitize_callback' => 'jalbee_sanitize_checkbox',
			'default'           => $value['default'],
		]
	);
}


// Hero Background section.
Jalbee_Kirki::add_section(
	'jalbee_hero_overlay_options',
	array(
		'title'       => esc_html__( 'Hero Overlay', 'jalbee' ),
		'panel'       => 'hero_panel',
		'description' => esc_html__( 'You can customize hero overlay according to your desire.', 'jalbee' ),
		'priority'    => 40,
	)
);

$overlay_colors = array(
	'hero_grad_start_color' => array(
		'label'   => __( 'Hero Gradient Start Color', 'jalbee' ),
		'default' => '#1284cd',
	),
	'hero_grad_end_color'   => array(
		'label'   => __( 'Hero Gradient End Color', 'jalbee' ),
		'default' => '#0ed18d',
	),
);

foreach ( $overlay_colors as $key => $value ) {
	Jalbee_Kirki::add_field(
		'jalbee',
		[
			'type'              => 'color',
			'settings'          => $key,
			'label'             => $value['label'],
			'section'           => 'jalbee_hero_overlay_options',
			'default'           => $value['default'],
			'sanitize_callback' => 'sanitize_hex_color',
			'choices'           => [
				'alpha' => true,
			],
		]
	);
}
	Jalbee_Kirki::add_field(
		'jalbee',
		[
			'type'              => 'slider',
			'settings'          => 'overlay_angle',
			'label'             => esc_html__( 'Overlay Angle', 'jalbee' ),
			'section'           => 'jalbee_hero_overlay_options',
			'default'           => 180,
			'sanitize_callback' => 'jalbee_sanitize_number_range',
			'choices'           => [
				'min'  => 0,
				'max'  => 360,
				'step' => 1,
			],
		]
	);

	Jalbee_Kirki::add_field(
		'jalbee',
		[
			'type'              => 'slider',
			'settings'          => 'hero_gradient_opacity',
			'label'             => esc_html__( 'Set Gradient Overlay Opacity', 'jalbee' ),
			'section'           => 'jalbee_hero_overlay_options',
			'default'           => 0.7,
			'sanitize_callback' => 'jalbee_sanitize_number_range',
			'choices'           => [
				'min'  => 0,
				'max'  => 1,
				'step' => .1,
			],
		]
	);

	// Hero General section.
	Jalbee_Kirki::add_section(
		'jalbee_hero_general_options',
		array(
			'title'       => esc_html__( 'Hero General Settings', 'jalbee' ),
			'panel'       => 'hero_panel',
			'description' => esc_html__( 'You can customize hero o to your desire.', 'jalbee' ),
			'priority'    => 5,
		)
	);

	Jalbee_Kirki::add_field(
		'jalbee',
		[
			'type'              => 'color',
			'settings'          => 'hero_font_color',
			'label'             => esc_html__( 'Hero Font Color', 'jalbee' ),
			'section'           => 'jalbee_hero_general_options',
			'default'           => '#f9f9f9',
			'sanitize_callback' => 'sanitize_hex_color',
		]
	);

	Jalbee_Kirki::add_field(
		'jalbee',
		[
			'type'              => 'select',
			'settings'          => 'hero_text_align',
			'label'             => esc_html__( 'This is the label', 'jalbee' ),
			'section'           => 'jalbee_hero_general_options',
			'default'           => 'center',
			'multiple'          => false,
			'sanitize_callback' => 'jalbee_sanitize_select',
			'choices'           => [
				'center'     => esc_html__( 'Center', 'jalbee' ),
				'flex-start' => esc_html__( 'Left', 'jalbee' ),
				'flex-end'   => esc_html__( 'Right', 'jalbee' ),
			],
		]
	);

	Jalbee_Kirki::add_field(
		'jalbee',
		[
			'type'              => 'checkbox',
			'settings'          => 'hero_full_height',
			'label'             => esc_html__( 'Make Hero Full Height', 'jalbee' ),
			'section'           => 'jalbee_hero_general_options',
			'sanitize_callback' => 'jalbee_sanitize_checkbox',
			'default'           => true,
		]
	);

	Jalbee_Kirki::add_field(
		'jalbee',
		[
			'type'              => 'dimension',
			'settings'          => 'hero_height',
			'label'             => esc_html__( 'Hero Height i.e 300px , 100vh', 'jalbee' ),
			'sanitize_callback' => 'esc_html',
			'section'           => 'jalbee_hero_general_options',
			'default'           => '',
		]
	);

	Jalbee_Kirki::add_field(
		'jalbee',
		[
			'type'              => 'checkbox',
			'settings'          => 'hide_drop_down',
			'label'             => esc_html__( 'Hide drop down ', 'jalbee' ),
			'section'           => 'jalbee_hero_general_options',
			'sanitize_callback' => 'jalbee_sanitize_checkbox',
			'default'           => false,
		]
	);
