<?php
/**
 * Jalbee Footer Customizer
 *
 * @package jalbee
 */

/**
 * Footer settings
 */

Jalbee_Kirki::add_section(
	'jalbee_footer_options',
	array(
		'title'       => esc_html__( 'Footer Settings', 'jalbee' ),
		'description' => esc_html__( 'Customize footer according to your desired.', 'jalbee' ),
	)
);

Jalbee_Kirki::add_field(
	'jalbee',
	[
		'type'              => 'checkbox',
		'settings'          => 'show-footer-text',
		'label'             => esc_html__( 'Show Footer text', 'jalbee' ),
		'tooltip'           => esc_html__( 'If you want to show check the box', 'jalbee' ),
		'section'           => 'jalbee_footer_options',
		'sanitize_callback' => 'jalbee_sanitize_checkbox',
		'default'           => true,
	]
);

Jalbee_Kirki::add_field(
	'jalbee',
	[
		'type'       => 'textarea',
		'settings'   => 'footer-text',
		'label'      => esc_html__( 'Footer text', 'jalbee' ),
		'default'    => '
		<a href="https://wordpress.org/">
		  Proudly powered by WordPress		</a>
		<span class="sep"> | </span>
		Theme by: <a href="#/">jalbee</a> .',
		// 'sanitize_callback' => 'esc_html',
		'capability' => 'manage_options',
		'section'    => 'jalbee_footer_options',
	]
);

Jalbee_Kirki::add_field(
	'jalbee',
	[
		'type'              => 'color',
		'settings'          => 'footer-background-color',
		'label'             => esc_html__( 'Footer Background Color', 'jalbee' ),
		'section'           => 'jalbee_footer_options',
		'default'           => '#f6f6f6',
		'sanitize_callback' => 'sanitize_hex_color',
	]
);
