<?php
/**
 * Jalbee Hero Customizer
 *
 * @package jalbee
 */

/**
 * Color settings
 * 
 */

$color_opinions = array(
	'heading-color' => array(
		'default' => '#32373c',
		'label' => esc_html__( 'Heading Color', 'jalbee' ),
	),
	'text-color' => array(
		'default' => '#333',
		'label' => esc_html__( 'Text Color', 'jalbee' ),
	),
	'link-color' => array(
		'default' => '#363b41',
		'label' => esc_html__( 'Link Color', 'jalbee' ),
	),
	'link-hover-color' => array(
		'default' => '#000',
		'label' => esc_html__( 'Link Hover Color', 'jalbee' ),
	),
	'menu-link-color' => array(
		'default' => '#000',
		'label' => esc_html__( 'Menu Link Color', 'jalbee' ),
	),
);

foreach ($color_opinions as $key => $value) {
	Jalbee_Kirki::add_field( 'jalbee', [
		'type'              => 'color',
		'settings'          => $key,
		'label'             => $value['label'],
		'section'           => 'colors',
		'default'           => $value['default'],
		'sanitize_callback' => 'sanitize_hex_color',
	] );
}
