<?php
/**
 * Customizer css.
 */


?>


<?php

$hero_background = get_theme_mod( 'hero_background' );
$overlay_angle   = get_theme_mod( 'overlay_angle' );

?>

<style type="text/css">

.hero-background{
  background-color: <?php echo esc_attr( $hero_background['background-color'] ); ?>;
  background-repeat: <?php echo esc_attr( $hero_background['background-repeat'] ); ?> !important;
  background-position: <?php echo esc_attr( $hero_background['background-position'] ); ?>;
  background-size: <?php echo esc_attr( $hero_background['background-size'] ); ?> !important;
  background-attachment: <?php echo esc_attr( $hero_background['background-attachment'] ); ?>;
  
}
.hero-content{
	align-items:<?php echo esc_attr( get_theme_mod( 'hero_text_align', 'center' ) ); ?> !important;
}

.hero-content .hero-title, .hero-content .hero-subtitle {
	color: <?php echo esc_attr( get_theme_mod( 'hero_font_color', '#f9f9f9' ) ); ?> !important;
}

.hero::before {
	background-image: linear-gradient(<?php echo esc_attr( $overlay_angle ); ?>deg, <?php echo esc_attr( get_theme_mod( 'hero_grad_start_color', '#1284cd' ) ); ?> , <?php echo esc_attr( get_theme_mod( 'hero_grad_end_color', '#0ed18d' ) ); ?>) !important;
	opacity: <?php echo esc_attr( get_theme_mod( 'hero_gradient_opacity', '0.7' ) ); ?> !important;
}

.hero:not(.hero-full-height) {
	height: <?php echo esc_attr( get_theme_mod( 'hero_height', '300px;' ) ); ?>
}
.site-footer{
	background-color: <?php echo esc_attr( get_theme_mod( 'footer-background-color', '#f6f6f6' ) ); ?>
}

h1,h2,h3,h4,h5,h6{
	color:<?php echo esc_attr( get_theme_mod( 'heading-color', '#32373c' ) ); ?>
}
body,
button,
input,
select,
optgroup,
textarea {
	color:<?php echo esc_attr( get_theme_mod( 'text-color', '#333' ) ); ?>
}

a {
	color: <?php echo esc_attr( get_theme_mod( 'link-color', '#363b41' ) ); ?>;
}

a:hover, a:focus, a:active {
	color: <?php echo esc_attr( get_theme_mod( 'link-hover-color', '#000' ) ); ?>;
}
.main-navigation a {
	color:<?php echo esc_attr( get_theme_mod( 'menu-link-color', '#000' ) ); ?>
}

.main-navigation .dropdown-toggle{
	color:<?php echo esc_attr( get_theme_mod( 'menu-link-color', '#000' ) ); ?>;
}
.main-navigation .dropdown-symbol{
	color:<?php echo esc_attr( get_theme_mod( 'menu-link-color', '#000' ) ); ?>;
	border-color:<?php echo esc_attr( get_theme_mod( 'menu-link-color', '#000' ) ); ?>	;
}
 </style>
