<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package jalbee
 */

?>
<!doctype html>
<html <?php language_attributes(); ?> class="no-js">
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1, minimum-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
<?php
if ( ! function_exists( 'wp_body_open' ) ) {
	function wp_body_open() {
			do_action( 'wp_body_open' );
	}
}
wp_body_open();

	$sticky_menu     = get_theme_mod( 'make-sticky-menu', true );
	$sticky_position = get_theme_mod( 'menu-position', 'after-hero' );

if ( ( is_home() || is_front_page() ) && ('after-hero' == $sticky_position || 'bottom' == $sticky_position ) ) {

	/**
*
* Include the Post-Type-specific template for the content.
* If you want to override this in a child theme, then include a file
* called content-___.php (where ___ is the Post Type name) and that will be used instead.
*/

get_template_part( 'template-parts/content', 'hero' );

}

?>
<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'jalbee' ); ?></a>

		<header id="masthead" class="site-header <?php echo $sticky_menu ? 'sticky' : ''; ?>  <?php echo esc_attr( $sticky_position ); ?>" 
		>
			<nav id="site-navigation" class="main-navigation " aria-label="<?php esc_attr_e( 'Main menu', 'jalbee' ); ?>"
				<?php if ( jalbee_is_amp() ) : ?>
					[class]=" siteNavigationMenu.expanded ? 'main-navigation toggled-on' : 'main-navigation' "
				<?php endif; ?>
			>
				<?php if ( jalbee_is_amp() ) : ?>
					<amp-state id="siteNavigationMenu">
						<script type="application/json">
							{
								"expanded": false
							}
						</script>
					</amp-state>
				<?php endif; ?>

				<button class="menu-toggle" aria-label="<?php esc_attr_e( 'Open menu', 'jalbee' ); ?>" aria-controls="primary-menu" aria-expanded="false"
					<?php if ( jalbee_is_amp() ) : ?>
						on="tap:AMP.setState( { siteNavigationMenu: { expanded: ! siteNavigationMenu.expanded } } )"
						[aria-expanded]="siteNavigationMenu.expanded ? 'true' : 'false'"
					<?php endif; ?>
				>
					<?php esc_html_e( 'Menu', 'jalbee' ); ?>
				</button>

				<div class="primary-menu-container">
					<?php

					wp_nav_menu(
						array(
							'theme_location' => 'primary',
							'menu_id'        => 'primary-menu',
							'container'      => 'ul',
						)
					);

					?>
				</div>
			</nav><!-- #site-navigation -->
		</header><!-- #masthead -->
<?php

if ( ( is_home() || is_front_page() ) &&  'top' == $sticky_position ) {

	/**
*
* Include the Post-Type-specific template for the content.
* If you want to override this in a child theme, then include a file
* called content-___.php (where ___ is the Post Type name) and that will be used instead.
*/

get_template_part( 'template-parts/content', 'hero' );

}


?>