<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package jalbee
 */

?>

<footer id="colophon" class="site-footer">
	<?php if ( is_active_sidebar( 'footer-widget' ) ) : ?>
	<div class="footer-widget-area">
		<?php
			dynamic_sidebar( 'footer-widget' );
		?>
	</div>
<?php endif; ?>

<?php
	if ( get_theme_mod( 'show-footer-text', true ) ) :;
?>
	<div class="site-info">
		
		<?php
		
		$site_info = get_theme_mod( 'footer-text');
		if(! $site_info ){

			?>
			<a href="<?php echo esc_url( __( 'https://wordpress.org/', 'jalbee' ) ); ?>" rel="nofollow">
			<?php
				/* translators: %s: WordPress. */
				printf( __( 'Proudly powered by %s.', 'jalbee' ), 'WordPress' );
				?>
				<span class="sep"> | </span> <?php _e( 'Theme by', 'jalbee' ); ?>: <a href="#/" rel="nofollow"><?php esc_html_e( 'jalbee', 'jalbee' ); ?></a>
			</a>
			<?php
		}else{
			echo wp_kses_post( $site_info );
			};?>
	</div><!-- .site-info -->
	<?php endif; // ?>
</footer><!-- #colophon -->
</div><!-- #page -->
<?php wp_footer(); ?>

</body>
</html>
