<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package Intech-It
 */

get_header();
?>

<!-- Start-Package-Section -->
<section class="ws-section-spacing single-blog <?php if( is_active_sidebar( 'footer-widget-area-1') || is_active_sidebar( 'footer-widget-area-2' ) ){?> space-bottom-90 <?php } ?>">
    <div class="container">
        <div class="row">
            <?php if(get_theme_mod('single_post_sidebar_layout') == "singel_left_sidebar" ) : ?>
                <!-- Side-bar -->
                <div class="col-lg-4 col-md-12">
                    <?php get_sidebar(); ?>
                </div>
            <?php endif; ?>
            <div class="<?php if(get_theme_mod('single_post_sidebar_layout') == "singel_no_sidebar" ) : ?> col-lg-12 <?php else: ?> col-lg-8 <?php endif; ?>">
            	<?php
				while ( have_posts() ) : the_post();

					get_template_part( 'template-parts/content', 'single' );

					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;
                endwhile; // End of the loop.
				?>
            </div>
            <?php if( get_theme_mod('single_post_sidebar_layout') == "singel_right_sidebar" ) : ?>
                <!-- Side-bar -->
                <div class="col-lg-4">
                    <?php get_sidebar(); ?>
                </div>
            <?php endif; ?>
        </div>
    </div>
</section>
<!-- End-Package-Section -->
<?php get_footer(); ?>