<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Intech-It
 */

get_header();
?>

	<!-- Start-Package-Section -->
    <section class="same-section-spacing single-blog <?php if( is_active_sidebar( 'footer-widget-area-1') || is_active_sidebar( 'footer-widget-area-2' ) ){?> space-bottom-90 <?php } ?>">
        <div class="container">
            <div class="row">
            	<?php if(get_theme_mod('blog_page_sidebar_layout') == "leftsidebar" ) : ?>
	                <!-- Side-bar -->
	                <div class="col-lg-4 col-md-12">
	                    <?php get_sidebar(); ?>
	                </div>
	            <?php endif; ?>
                <div class="<?php if(get_theme_mod('blog_page_sidebar_layout') == "nosidebar" ) : ?> col-lg-12 <?php else: ?> col-lg-8 <?php endif; ?>">
					<?php
					if ( have_posts() ) :

						/* Start the Loop */
						while ( have_posts() ) :
							the_post();

							/*
							 * Include the Post-Type-specific template for the content.
							 * If you want to override this in a child theme, then include a file
							 * called content-___.php (where ___ is the Post Type name) and that will be used instead.
							 */
							get_template_part( 'template-parts/content', get_post_type() );

						endwhile;

						?>
						<nav class="pagination-outer mt-4" aria-label="Page navigation">
                            
							<?php // Previous/next page navigation.
							the_posts_pagination( array(
							'prev_text'          => '<i class="fas fa-angle-double-left"></i>',
							'next_text'          => '<i class="fas fa-angle-double-right"></i>',
							) ); ?>
							
						</nav>
					<?php
					else :
						get_template_part( 'template-parts/content', 'none' );
					endif;
					?>
                </div>
                <?php if(get_theme_mod('blog_page_sidebar_layout') == "rightsidebar" ) : ?>
	                <!-- Side-bar -->
	                <div class="col-lg-4">
	                    <?php get_sidebar(); ?>
	                </div>
	            <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- End-Package-Section -->
<?php get_footer(); ?>