<?php
/**
 * Title: Services
 * Slug: gutenic/services
 * Categories: services
 * Block Types: core/template-part/services
 */

$gutenic_get_url = trailingslashit( get_template_directory_uri() );

$gutenic_images = [
    $gutenic_get_url . "assets/image/tax-planing.png",
    $gutenic_get_url . "assets/image/audit-services.png",
    $gutenic_get_url . "assets/image/financial-consulting.png",
    $gutenic_get_url . "assets/image/payroll-processing.png",
    $gutenic_get_url . "assets/image/tax-preparation.png",
    $gutenic_get_url . "assets/image/bookkeeping.png",
];

register_block_pattern(
    'gutenic/services',
    array(
        'title'       => __( 'Services', 'gutenic' ),
        'description' => _x( 'Custom services pattern.', 'Block pattern description', 'gutenic' ),
        'content'     => '<!-- wp:group {"layout":{"type":"constrained"}} -->
<div class="wp-block-group"><!-- wp:paragraph {"align":"center","style":{"color":{"text":"#3c414d"},"elements":{"link":{"color":{"text":"#3c414d"}}},"typography":{"textTransform":"uppercase","fontSize":"14px"}}} -->
<p class="has-text-align-center has-text-color has-link-color" style="color:#3c414d;font-size:14px;text-transform:uppercase"><strong><mark style="background-color:rgba(0, 0, 0, 0);color:#c6c8cc" class="has-inline-color">//</mark> Top Services</strong></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"textAlign":"center","style":{"spacing":{"margin":{"top":"10px"}}}} -->
<h2 class="wp-block-heading has-text-align-center" style="margin-top:10px">Industries we specialize in</h2>
<!-- /wp:heading -->

<!-- wp:spacer {"height":"40px"} -->
<div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
<!-- /wp:spacer -->

<!-- wp:columns {"style":{"border":{"top":{"width":"0px","style":"none"},"right":{"width":"0px","style":"none"},"bottom":{"color":"#e1e1e1","width":"1px"},"left":{"width":"0px","style":"none"}}}} -->
<div class="wp-block-columns" style="border-top-style:none;border-top-width:0px;border-right-style:none;border-right-width:0px;border-bottom-color:#e1e1e1;border-bottom-width:1px;border-left-style:none;border-left-width:0px"><!-- wp:column {"style":{"spacing":{"padding":{"top":"30px","bottom":"30px","left":"30px","right":"30px"}}}} -->
<div class="wp-block-column" style="padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:image {"id":382,"width":"80px","height":"80px","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( $gutenic_images[0] ) . '" alt="Tax Planing" class="wp-image-382" style="object-fit:cover;width:80px;height:80px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4 class="wp-block-heading">Tax Planing</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"color":{"text":"#515151"},"elements":{"link":{"color":{"text":"#515151"}}}}} -->
<p class="has-text-color has-link-color" style="color:#515151"><a href="#" target="_blank" rel="noreferrer noopener"><strong>Learn more →</strong></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"border":{"top":{"width":"0px","style":"none"},"right":{"color":"#e1e1e1","width":"1px"},"bottom":{"width":"0px","style":"none"},"left":{"color":"#e1e1e1","width":"1px"}},"spacing":{"padding":{"top":"30px","bottom":"30px","left":"30px","right":"30px"}}}} -->
<div class="wp-block-column" style="border-top-style:none;border-top-width:0px;border-right-color:#e1e1e1;border-right-width:1px;border-bottom-style:none;border-bottom-width:0px;border-left-color:#e1e1e1;border-left-width:1px;padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:image {"id":382,"width":"80px","height":"80px","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( $gutenic_images[1] ) . '" alt="Audit Services" class="wp-image-382" style="object-fit:cover;width:80px;height:80px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4 class="wp-block-heading">Audit Services</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"color":{"text":"#515151"},"elements":{"link":{"color":{"text":"#515151"}}}}} -->
<p class="has-text-color has-link-color" style="color:#515151"><a href="#" target="_blank" rel="noreferrer noopener"><strong>Learn more →</strong></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"padding":{"top":"30px","bottom":"30px","left":"30px","right":"30px"}}}} -->
<div class="wp-block-column" style="padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:image {"id":382,"width":"80px","height":"80px","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( $gutenic_images[2] ) . '" alt="Financial Consulting" class="wp-image-382" style="object-fit:cover;width:80px;height:80px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4 class="wp-block-heading">Financial Consulting</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"color":{"text":"#515151"},"elements":{"link":{"color":{"text":"#515151"}}}}} -->
<p class="has-text-color has-link-color" style="color:#515151"><a href="#" target="_blank" rel="noreferrer noopener"><strong>Learn more →</strong></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns -->

<!-- wp:columns {"style":{"spacing":{"margin":{"top":"0px"}}}} -->
<div class="wp-block-columns" style="margin-top:0px"><!-- wp:column {"style":{"spacing":{"padding":{"top":"30px","bottom":"30px","left":"30px","right":"30px"}}}} -->
<div class="wp-block-column" style="padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:image {"id":382,"width":"80px","height":"80px","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( $gutenic_images[3] ) . '" alt="Payroll Processing" class="wp-image-382" style="object-fit:cover;width:80px;height:80px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4 class="wp-block-heading">Payroll Processing</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"color":{"text":"#515151"},"elements":{"link":{"color":{"text":"#515151"}}}}} -->
<p class="has-text-color has-link-color" style="color:#515151"><a href="#" target="_blank" rel="noreferrer noopener"><strong>Learn more →</strong></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"border":{"top":{"width":"0px","style":"none"},"right":{"color":"#e1e1e1","width":"1px"},"bottom":{"width":"0px","style":"none"},"left":{"color":"#e1e1e1","width":"1px"}},"spacing":{"padding":{"top":"30px","bottom":"30px","left":"30px","right":"30px"}}}} -->
<div class="wp-block-column" style="border-top-style:none;border-top-width:0px;border-right-color:#e1e1e1;border-right-width:1px;border-bottom-style:none;border-bottom-width:0px;border-left-color:#e1e1e1;border-left-width:1px;padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:image {"id":382,"width":"80px","height":"80px","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( $gutenic_images[4] ) . '" alt="Tax preparation" class="wp-image-382" style="object-fit:cover;width:80px;height:80px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4 class="wp-block-heading">Tax preparation</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"color":{"text":"#515151"},"elements":{"link":{"color":{"text":"#515151"}}}}} -->
<p class="has-text-color has-link-color" style="color:#515151"><a href="#" target="_blank" rel="noreferrer noopener"><strong>Learn more →</strong></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column -->

<!-- wp:column {"style":{"spacing":{"padding":{"top":"30px","bottom":"30px","left":"30px","right":"30px"}}}} -->
<div class="wp-block-column" style="padding-top:30px;padding-right:30px;padding-bottom:30px;padding-left:30px"><!-- wp:image {"id":382,"width":"80px","height":"80px","scale":"cover","sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full is-resized"><img src="' . esc_url( $gutenic_images[5] ) . '" alt="Bookkeeping" class="wp-image-382" style="object-fit:cover;width:80px;height:80px"/></figure>
<!-- /wp:image -->

<!-- wp:heading {"level":4} -->
<h4 class="wp-block-heading">Bookkeeping</h4>
<!-- /wp:heading -->

<!-- wp:paragraph -->
<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit.</p>
<!-- /wp:paragraph -->

<!-- wp:paragraph {"style":{"color":{"text":"#515151"},"elements":{"link":{"color":{"text":"#515151"}}}}} -->
<p class="has-text-color has-link-color" style="color:#515151"><a href="#" target="_blank" rel="noreferrer noopener"><strong>Learn more →</strong></a></p>
<!-- /wp:paragraph --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->',
        'categories'  => array( 'services' ),
    )
);
