<?php
/**
 * Title: Hero
 * Slug: gutenic/hero
 * Categories: hero
 * Block Types: core/template-part/hero
 */

$gutenic_get_url = trailingslashit( get_template_directory_uri() );

$gutenic_images = [
    $gutenic_get_url . "assets/image/default-hero.png",
];

register_block_pattern(
    'gutenic/hero',
    array(
        'title'       => __( 'Hero', 'gutenic' ),
        'description' => _x( 'Custom hero pattern.', 'Block pattern description', 'gutenic' ),
        'content'     => '<!-- wp:group {"align":"full","style":{"color":{"background":"#f9fafb"},"spacing":{"padding":{"top":"40px","bottom":"0px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-background" style="background-color:#f9fafb;padding-top:40px;padding-bottom:0px"><!-- wp:columns {"verticalAlignment":"center"} -->
<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:paragraph {"style":{"color":{"text":"#3c414d"},"elements":{"link":{"color":{"text":"#3c414d"}}},"typography":{"textTransform":"uppercase","fontSize":"14px"}}} -->
<p class="has-text-color has-link-color" style="color:#3c414d;font-size:14px;text-transform:uppercase"><strong><mark style="background-color:rgba(0, 0, 0, 0);color:#c6c8cc" class="has-inline-color">//</mark> Welcome to Gutenic</strong></p>
<!-- /wp:paragraph -->

<!-- wp:heading {"level":1,"style":{"color":{"text":"#3c414d"},"elements":{"link":{"color":{"text":"#3c414d"}}},"typography":{"fontSize":"49px"}}} -->
<h1 class="wp-block-heading has-text-color has-link-color" style="color:#3c414d;font-size:49px">Together, we can grow your business.</h1>
<!-- /wp:heading -->

<!-- wp:group {"style":{"spacing":{"padding":{"top":"20px","bottom":"20px"}}},"layout":{"type":"constrained","contentSize":"400px","justifyContent":"left"}} -->
<div class="wp-block-group" style="padding-top:20px;padding-bottom:20px"><!-- wp:paragraph -->
<p>Upgrade your business with Gutenic, a high-quality Gutenberg template.</p>
<!-- /wp:paragraph --></div>
<!-- /wp:group -->

<!-- wp:buttons -->
<div class="wp-block-buttons"><!-- wp:button {"style":{"spacing":{"padding":{"left":"22px","right":"22px","top":"18px","bottom":"18px"}},"typography":{"fontSize":"19px"}}} -->
<div class="wp-block-button has-custom-font-size" style="font-size:19px"><a class="wp-block-button__link wp-element-button" style="padding-top:18px;padding-right:22px;padding-bottom:18px;padding-left:22px">Getting Started!</a></div>
<!-- /wp:button --></div>
<!-- /wp:buttons --></div>
<!-- /wp:column -->

<!-- wp:column {"verticalAlignment":"center"} -->
<div class="wp-block-column is-vertically-aligned-center"><!-- wp:image {"id":348,"sizeSlug":"full","linkDestination":"none"} -->
<figure class="wp-block-image size-full"><img src="' . esc_url( $gutenic_images[0] ) . '" alt="Hero Person"/></figure>
<!-- /wp:image --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->',
        'categories'  => array( 'header' ),
    )
);
