<?php
/**
 * Title: Header
 * Slug: gutenic/header
 * Categories: header
 * Block Types: core/template-part/header
 */

$gutenic_get_url = trailingslashit( get_template_directory_uri() );

$gutenic_images = [
    $gutenic_get_url . "assets/image/default-logo.png",
];

register_block_pattern(
    'gutenic/header',
    array(
        'title'       => __( 'Header', 'gutenic' ),
        'description' => _x( 'Custom header pattern.', 'Block pattern description', 'gutenic' ),
        'content'     => '<!-- wp:group {"style":{"position":{"type":""},"color":{"background":"var(--wp--preset--color--primary)"},"elements":{"link":{"color":{"text":"var:preset|color|white"},":hover":{"color":{"text":"#767a82"}}}}},"textColor":"white","layout":{"type":"constrained","contentSize":"1200px"}} -->
<div class="wp-block-group has-white-color has-text-color has-background has-link-color" style="background-color:var(--wp--preset--color--primary)"><!-- wp:columns {"verticalAlignment":"center","className":"frhd-gn-default-header-cols"} -->
<div class="wp-block-columns are-vertically-aligned-center frhd-gn-default-header-cols"><!-- wp:column -->
<div class="wp-block-column"><!-- wp:image {"sizeSlug":"full","linkDestination":"none","align":"left"} -->
<figure class="wp-block-image alignleft size-full"><a href="' . esc_url( home_url() ) . '"><img src="' . esc_url( $gutenic_images[0] ) . '" alt="Default Logo"/></a></figure>
<!-- /wp:image --></div>
<!-- /wp:column -->

<!-- wp:column {"className":"frhd-gn-default-header-col-right","style":{"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
<div class="wp-block-column frhd-gn-default-header-col-right has-white-color has-text-color has-link-color"><!-- wp:navigation {"layout":{"type":"flex","justifyContent":"right"}} -->
<!-- wp:navigation-link {"label":"Home","url":"#"} /-->

<!-- wp:navigation-link {"label":"About Us","url":"#"} /-->

<!-- wp:navigation-link {"label":"Blog","url":"#"} /-->

<!-- wp:navigation-link {"label":"Contact Us","url":"#"} /-->
<!-- /wp:navigation --></div>
<!-- /wp:column --></div>
<!-- /wp:columns --></div>
<!-- /wp:group -->',
        'categories'  => array( 'header' ),
    )
);
