<?php
/**
 * Title: Call to Action
 * Slug: gutenic/call-to-action
 * Categories: call-to-action
 * Block Types: core/template-part/call-to-action
 */

register_block_pattern(
    'gutenic/call-to-action',
    array(
        'title'       => __( 'Call-to-action', 'gutenic' ),
        'description' => _x( 'Custom call-to-action pattern.', 'Block pattern description', 'gutenic' ),
        'content'     => '<!-- wp:group {"align":"full","style":{"color":{"background":"#022a41"},"spacing":{"padding":{"top":"100px","bottom":"100px"}}},"layout":{"type":"constrained"}} -->
<div class="wp-block-group alignfull has-background" style="background-color:#022a41;padding-top:100px;padding-bottom:100px"><!-- wp:columns {"verticalAlignment":"center"} -->
	<div class="wp-block-columns are-vertically-aligned-center"><!-- wp:column {"verticalAlignment":"center","width":"66.66%"} -->
	<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:66.66%"><!-- wp:heading {"style":{"typography":{"fontSize":"48px"},"elements":{"link":{"color":{"text":"var:preset|color|white"}}}},"textColor":"white"} -->
	<h2 class="wp-block-heading has-white-color has-text-color has-link-color" style="font-size:48px">Let\'s Talk!</h2>
	<!-- /wp:heading -->
	
	<!-- wp:paragraph {"style":{"elements":{"link":{"color":{"text":"#cbcbcb"}}},"typography":{"fontSize":"20px"},"color":{"text":"#cbcbcb"}}} -->
	<p class="has-text-color has-link-color" style="color:#cbcbcb;font-size:20px"><strong>Please feel free to contact us. We’re super happy to talk to you.</strong></p>
	<!-- /wp:paragraph --></div>
	<!-- /wp:column -->
	
	<!-- wp:column {"verticalAlignment":"center","width":"33.33%"} -->
	<div class="wp-block-column is-vertically-aligned-center" style="flex-basis:33.33%"><!-- wp:buttons {"layout":{"type":"flex","justifyContent":"center"}} -->
	<div class="wp-block-buttons"><!-- wp:button {"backgroundColor":"white","className":"is-style-outline","style":{"spacing":{"padding":{"left":"38px","right":"38px","top":"22px","bottom":"22px"}},"typography":{"fontSize":"19px"},"color":{"text":"#022a41"},"elements":{"link":{"color":{"text":"#022a41"}}}}} -->
	<div class="wp-block-button has-custom-font-size is-style-outline" style="font-size:19px"><a class="wp-block-button__link has-white-background-color has-text-color has-background has-link-color wp-element-button" style="color:#022a41;padding-top:22px;padding-right:38px;padding-bottom:22px;padding-left:38px">Contact Us →</a></div>
	<!-- /wp:button --></div>
	<!-- /wp:buttons --></div>
	<!-- /wp:column --></div>
	<!-- /wp:columns --></div>
	<!-- /wp:group -->',
        'categories'  => array( 'call-to-action' ),
    )
);
