<?php
if ( ! function_exists( 'gutenic_themes_starter_theme_support' ) ) {
	/**
	 * General Theme Settings.
	 *
	 * @since v1.0
	 *
	 * @return void
	 */
	function gutenic_themes_starter_theme_support() {
		// Make theme available for translation: Translations can be filed in the /languages/ directory.
		load_theme_textdomain( 'gutenic', __DIR__ . '/languages' );

		// Add support for Post thumbnails.
		add_theme_support( 'post-thumbnails' );
		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );
		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for Editor Styles.
		add_theme_support( 'editor-styles' );
		// Enqueue Editor Styles.
		add_editor_style( 'style-editor.css' );

		// Register block patterns
		gutenic_register_block_patterns();
	}
	add_action( 'after_setup_theme', 'gutenic_themes_starter_theme_support' );

	/**
	 * Enqueue editor stylesheet (for iframed Post Editor):
	 * https://make.wordpress.org/core/2023/07/18/miscellaneous-editor-changes-in-wordpress-6-3/#post-editor-iframed
	 *
	 * @since v1.2.2
	 *
	 * @return void
	 */
	function gutenic_themes_starter_load_editor_styles() {
		if ( is_admin() ) {
			wp_enqueue_style( 'editor-style', get_theme_file_uri( 'style-editor.css' ) );
		}
	}
	add_action( 'enqueue_block_assets', 'gutenic_themes_starter_load_editor_styles' );

	// Disable Block Directory: https://github.com/WordPress/gutenberg/blob/trunk/docs/reference-guides/filters/editor-filters.md#block-directory
	remove_action( 'enqueue_block_editor_assets', 'wp_enqueue_editor_block_directory_assets' );
	remove_action( 'enqueue_block_editor_assets', 'gutenberg_enqueue_block_editor_assets_block_directory' );
}

/**
 * Custom Template part.
 *
 * @param array $areas Template part areas.
 *
 * @return array
 */
function gutenic_themes_starter_custom_template_part_area( $areas ) {
	array_push(
		$areas,
		array(
			'area'        => 'query',
			'label'       => esc_html__( 'Query', 'gutenic' ),
			'description' => esc_html__( 'Custom query area', 'gutenic' ),
			'icon'        => 'layout',
			'area_tag'    => 'div',
		)
	);

	return $areas;
}
add_filter( 'default_wp_template_part_areas', 'gutenic_themes_starter_custom_template_part_area' );

if ( ! function_exists( 'gutenic_themes_starter_load_scripts' ) ) {
	/**
	 * Enqueue CSS Stylesheets and Javascript files.
	 *
	 * @return void
	 */
	function gutenic_themes_starter_load_scripts() {
		$theme_version = wp_get_theme()->get( 'Version' );

		// 1. Styles.
		wp_enqueue_style( 'style', get_stylesheet_uri(), array(), $theme_version );
		wp_enqueue_style( 'main', get_theme_file_uri( 'build/main.css' ), array(), $theme_version, 'all' ); // main.scss: Compiled custom styles.

		if ( is_rtl() ) {
			wp_enqueue_style( 'rtl', get_theme_file_uri( 'build/rtl.css' ), array(), $theme_version, 'all' );
		}

		// 2. Scripts.
		wp_enqueue_script( 'mainjs', get_theme_file_uri( 'build/main.js' ), array(), $theme_version, true );
	}
	add_action( 'wp_enqueue_scripts', 'gutenic_themes_starter_load_scripts' );
}

/**
 * Add the Editor page to the admin header menu.
 */
function gutenic_add_editor_to_admin_bar($wp_admin_bar) {
    if (!is_admin()) {
        return;
    }

    $args = array(
        'id'    => 'site-editor',
        'title' => __( 'Editor', 'gutenic' ),
        'href'  => admin_url('site-editor.php'),
        'meta'  => array(
            'class' => 'site-editor'
        )
    );
    $wp_admin_bar->add_node($args);
}
add_action('admin_bar_menu', 'gutenic_add_editor_to_admin_bar', 999);

/**
 * Adding Theme File Editor (also known as the Theme Editor) menu under the Appearance.
 * In some installations, file editing via the WordPress admin panel is disabled for security reasons.
 * In this case you can add below code in `wp-config.php`
 * define('DISALLOW_FILE_EDIT', false);
 */
function gutenic_frhd_gnic_theme_plugin_editor_menu() {

	add_theme_page(
        __('Theme Editor', 'gutenic'),
        __('Theme Editor', 'gutenic'),
        'edit_themes',
        'theme-editor.php'
    );

	add_plugins_page(
        __('Plugin Editor', 'gutenic'),
        __('Plugin Editor', 'gutenic'),
        'edit_plugins',
        'plugin-editor.php'
    );

    add_theme_page(
        __('Customize', 'gutenic'),
        __('Customize', 'gutenic'),
        'customize',
        'customize.php'
    );
}
add_action('admin_menu', 'gutenic_frhd_gnic_theme_plugin_editor_menu');

/**
 * Register block patterns.
 */
function gutenic_register_block_patterns() {

    $pattern_directory = get_template_directory() . '/patterns';

    foreach (glob($pattern_directory . '/*.php') as $file) {

        require $file;
    }
}

/**
 * Register block styles.
 */
function gutenic_gutenic_register_block_styles() {

    // Register a new style for the button block.
    register_block_style(
        'core/button',
        array(
            'name'  => 'gutenic-button',
            'label' => __('Gutenic', 'gutenic'),
        )
    );
}
add_action('init', 'gutenic_gutenic_register_block_styles');
