<?php
/**
 * Template part for Post Ticker
 *
 * @package Graceful Media Blog
 */
if (graceful_options('basic_slider_width') === 'wrapped') {
    $graceful_slider_width = 'wrapped-content';
} else {
    $graceful_slider_width = '';
}
?>

<div class="graceful-latest <?php echo esc_attr( $graceful_slider_width ); ?>">
    
    <div id="graceful-latest-posts-ticker" class="graceful-latest-posts-ticker owl-carousel owl-theme">
        <?php
        // WP_Query to retrieve latest posts based on comment count.
        $graceful_latest_posts = new WP_Query( array(
            'posts_per_page' => 5,
            'order'          => 'DESC',
            'post_status'    => 'publish',
        ) );

        if ( $graceful_latest_posts->have_posts() ) :
            while ( $graceful_latest_posts->have_posts() ) : $graceful_latest_posts->the_post();
                // Calculate read time (approximately 200 words per minute)
                $content = get_the_content();
                $word_count = str_word_count( wp_strip_all_tags( $content ) );
                $read_time = ceil($word_count / 200);
                $read_time = max(1, $read_time); // Minimum 1 minute read time
            ?>
                <div class="item">
                    <div class="post-card post-card-overlay">
                        <div class="post-image">
                            <?php if ( has_post_thumbnail() ) : ?>
                                <?php the_post_thumbnail('full'); ?>
                            <?php else : ?>
                                <div class="no-thumbnail"></div>
                            <?php endif; ?>
                        </div>
                        <div class="post-overlay-content">
                            <div class="post-category">
                                <?php 
                                    $categories = get_the_category();
                                    if ( ! empty( $categories ) ) {
                                        echo esc_html( $categories[0]->name );
                                    }
                                ?>
                            </div>
                            <h3 class="post-title">
                                <a href="<?php echo esc_url(get_permalink()); ?>"><?php echo esc_html(get_the_title()); ?></a>
                            </h3>
                            <div class="post-meta">
                                <span class="post-date"><?php echo esc_html(get_the_date('F j, Y')); ?></span>
                            </div>
                        </div>
                    </div>
                </div>

            <?php endwhile;
            wp_reset_postdata();
        endif;
        ?>
    </div>

</div>

<script type="text/javascript">
    jQuery(document).ready(function($) {
        $('.graceful-latest-posts-ticker').owlCarousel({
            items: 1,
            loop: true,
            margin: 24,
            autoplay: false,
            autoplayTimeout: 3000,
            autoplayHoverPause: true,
            nav: true,
            dots: false,
            responsive: {
                0: {
                    items: 1
                },
                768: {
                    items: 1
                },
                1200: {
                    items: 1
                }
            }
        });
    });
</script>