<?php
/**
 * Template part for displaying Posts in One Column
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package Graceful
 */

$graceful_category_tags_allowed = array(
    'a' => array(
        'href' => array(),
        'rel' 		=> array()
    ),
    'div' => array(
        'class' => array()
    )
);
?>
<div class="content-wrap">
	<?php if ( is_search() ) : ?>
	<h1>
		<?php
		printf(
			/* translators: %s: search query */
			esc_html__( 'Search Results for: %s', 'graceful-media-blog' ),
			'<span>' . esc_html( get_search_query() ) . '</span>'
		);
		?>
	</h1>
	<?php endif; ?>
	<?php if ( is_category() ) { ?>
		<h1 class="graceful-media-category-title">
		    <?php echo esc_html( single_cat_title( '', false ) ); ?>
		</h1>
	<?php } ?>
	<?php if ( is_home() && graceful_media_blog_options( 'latest_article_heading_text' ) !== '') { ?>
		<style type="text/css">
			.graceful-latest-articles span {
				display: block;
			    padding: 3px 12px 5px;
			    background-color: <?php echo esc_attr( graceful_media_blog_options( 'latest_article_heading_bg_color' ) ) ?> !important;
			    color: <?php echo esc_attr( graceful_media_blog_options( 'latest_article_heading_text_color' ) ) ?> !important;
			    text-align: center;
			    font-family: 'Lato', sans-serif;
			    font-weight: 500;
			    font-size: 24px;
			}
		</style>
		<h3 class="graceful-latest-articles">
			<span><?php echo esc_html( graceful_media_blog_options( 'latest_article_heading_text' ) ); ?></span>
		</h3>
	<?php } ?>
	<ul class="content-column graceful-media-column">
		<?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
			<li>
			  <article id="post-<?php the_ID(); ?>" <?php post_class('content-post'); ?>>
			    <div class="site-images overlay-post">

			      <?php if ( has_post_thumbnail() ) : ?>
			        <a href="<?php echo esc_url( get_permalink() ); ?>">
			          <?php the_post_thumbnail('graceful-post-column-thumbnail'); ?>
			        </a>
			      <?php else : ?>
			      	<a href="<?php echo esc_url( get_permalink() ); ?>">
				       <div class="no-thumbnail"></div>
				    </a>
				  <?php endif; ?>

			      <div class="image-overlay">
			        <?php
			        $graceful_category_list = get_the_category_list( '&nbsp;-&nbsp;' );
			        if ( graceful_options( 'post_page_show_categories' ) && $graceful_category_list ) :
			        ?>
			          <div class="post-categories">
			            <?php echo wp_kses( $graceful_category_list, $graceful_category_tags_allowed ); ?>
			          </div>
			        <?php endif; ?>

			        <h2 class="post-title">
			          <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
			        </h2>
			      </div>
			    </div>
			  </article>
			</li>

		<?php endwhile; else: ?>
			<div class="no-result-found">
				<h3><?php esc_html_e( 'Nothing Found!', 'graceful-media-blog' ); ?></h3>
				<p><?php esc_html_e( 'Sorry, but nothing matched your search terms. Please try again with some different keywords.', 'graceful-media-blog' ); ?></p>
				<div class="graceful-widget widget_search">
					<?php get_search_form(); ?>
				</div>
			</div>
		<?php endif; //have_posts ?>
	</ul>
	<?php get_template_part( 'template-parts/sections/site', 'pagination' ); ?>
</div><!-- content-wrap -->