<?php
/**
 * Template part for Special Links below Header
 *
 * @package Graceful Lite
 */

// Open the links in New Tab
$graceful_links_window = ( graceful_lite_options( 'special_links_window' ) )?'_blank':'_self';
?>

<div id="special-links" class="<?php echo esc_attr( graceful_lite_options( 'special_links_width' ) ) === 'wrapped' ? ' wrapped-content': ''; ?> clear-fix">
	<!-- Link No 1 -->
	<?php if ( graceful_lite_options( 'special_links_image_1' ) !== '' ): ?>
	<div class="special-link">
		<img src="<?php echo esc_url( wp_get_attachment_url( graceful_lite_options( 'special_links_image_1' ) ) ); ?>" alt="<?php echo esc_html( graceful_lite_options( 'special_links_title_1' ) ); ?>">
		<a href="<?php echo esc_url( graceful_lite_options( 'special_links_url_1' ) ); ?>" target="<?php echo esc_attr($graceful_links_window); ?>">
			<div class="graceful-wrap-outer">
				<div class="graceful-wrap-inner">
					<h4><?php echo esc_html( graceful_lite_options( 'special_links_title_1' ) ); ?></h4>
				</div>
			</div>
		</a>
	</div>
	<?php endif; ?>

	<!-- Link No 2 -->
	<?php if ( graceful_lite_options( 'special_links_image_2' ) !== '' ): ?>
	<div class="special-link">
		<img src="<?php echo esc_url( wp_get_attachment_url( graceful_lite_options( 'special_links_image_2' ) ) ); ?>" alt="<?php echo esc_html( graceful_lite_options( 'special_links_title_2' ) ); ?>">
		<a href="<?php echo esc_url( graceful_lite_options( 'special_links_url_2' ) ); ?>" target="<?php echo esc_attr($graceful_links_window); ?>">
			<div class="graceful-wrap-outer">
				<div class="graceful-wrap-inner">
					<h4><?php echo esc_html( graceful_lite_options( 'special_links_title_2' ) ); ?></h4>
				</div>
			</div>
		</a>
	</div>
	<?php endif; ?>

	<!-- Link No 3 -->
	<?php if ( graceful_lite_options( 'special_links_image_3' ) !== '' ): ?>
	<div class="special-link">
		<img src="<?php echo esc_url( wp_get_attachment_url( graceful_lite_options( 'special_links_image_3' ) ) ); ?>" alt="<?php echo esc_html( graceful_lite_options( 'special_links_title_3' ) ); ?>">
		<a href="<?php echo esc_url( graceful_lite_options( 'special_links_url_3' ) ); ?>" target="<?php echo esc_attr($graceful_links_window); ?>">
			<div class="graceful-wrap-outer">
				<div class="graceful-wrap-inner">
					<h4><?php echo esc_html( graceful_lite_options( 'special_links_title_3' ) ); ?></h4>
				</div>
			</div>
		</a>
	</div>
	<?php endif; ?>

</div><!-- #special-links end -->