<?php
/**
 * Graceful Lite functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Graceful Lite
 */

// ----------------------------------------------------------------------------------
//	Register Front-End Styles And Scripts
// ----------------------------------------------------------------------------------

function graceful_lite_enqueue_child_styles() {
 
    wp_enqueue_style( 'graceful-style', get_template_directory_uri() . '/style.css' );
    wp_enqueue_style( 'graceful-lite-style', get_stylesheet_directory_uri() . '/style.css', array( 'graceful-style' ), wp_get_theme()->get('Version') );
}
add_action( 'wp_enqueue_scripts', 'graceful_lite_enqueue_child_styles' );


// ----------------------------------------------------------------------------------
//  Customize Register for Special Links Section
// ----------------------------------------------------------------------------------
function graceful_lite_customize_register( $wp_customize ) {    

    /** Special Links */
    // Special Links section
    $wp_customize->add_section( 'graceful_lite_special_links' , array(
        'title'      => esc_html__( 'Special Links', 'graceful-lite' ),
        'priority'   => 27,
        'capability' => 'edit_theme_options'
    ) );

    // Special Links 1
    $wp_customize->add_setting( 'graceful_lite_options[special_links_show]', array(
        'default'    => graceful_lite_options( 'special_links_show' ),
        'type'       => 'option',
        'transport'  => 'refresh',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'graceful_sanitize_checkboxes'
    ) );
    $wp_customize->add_control( 'graceful_lite_options[special_links_show]', array(
        'label'     => esc_html__( 'Enable Special Links', 'graceful-lite' ),
        'section'   => 'graceful_lite_special_links',
        'type'      => 'checkbox',
        'priority'  => 1
    ) );


    $wp_customize->add_setting( 'graceful_lite_options[special_links_title_1]', array(
        'default'    => graceful_lite_options( 'special_links_title_1' ),
        'type'       => 'option',
        'transport'  => 'refresh',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ) );
    $wp_customize->add_control( 'graceful_lite_options[special_links_title_1]', array(
        'label'     => esc_html__( 'Title 1', 'graceful-lite' ),
        'section'   => 'graceful_lite_special_links',
        'type'      => 'text',
        'priority'  => 9
    ) );

    $wp_customize->add_setting( 'graceful_lite_options[special_links_url_1]', array(
        'default'    => graceful_lite_options( 'special_links_url_1' ),
        'type'       => 'option',
        'transport'  => 'refresh',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
    ) );
    $wp_customize->add_control( 'graceful_lite_options[special_links_url_1]', array(
        'label'     => esc_html__( 'URL 1', 'graceful-lite' ),
        'section'   => 'graceful_lite_special_links',
        'type'      => 'text',
        'priority'  => 11
    ) );

    $wp_customize->add_setting( 'graceful_lite_options[special_links_image_1]', array(
        'default'   => '',
        'type'      => 'option',
        'transport' => 'refresh',
        'sanitize_callback' => 'graceful_sanitize_number_absint'
    ) );
    $wp_customize->add_control(
        new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_lite_options[special_links_image_1]', array(
            'label'         => esc_html__( 'Image 1', 'graceful-lite' ),
            'section'       => 'graceful_lite_special_links',
            'flex_width'    => false,
            'flex_height'   => false,
            'width'         => 600,
            'height'        => 340,
            'priority'      => 13
        )
    ) );

    // Special Links Enable
    $wp_customize->add_setting( 'graceful_lite_options[special_links_show]', array(
        'default'    => graceful_lite_options( 'special_links_show' ),
        'type'       => 'option',
        'transport'  => 'refresh',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'graceful_sanitize_checkboxes'
    ) );
    $wp_customize->add_control( 'graceful_lite_options[special_links_show]', array(
        'label'     => esc_html__( 'Enable Special Links', 'graceful-lite' ),
        'section'   => 'graceful_lite_special_links',
        'type'      => 'checkbox',
        'priority'  => 1
    ) );

    // Special Links 1
    $wp_customize->add_setting( 'graceful_lite_options[special_links_title_1]', array(
        'default'    => graceful_lite_options( 'special_links_title_1' ),
        'type'       => 'option',
        'transport'  => 'refresh',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ) );
    $wp_customize->add_control( 'graceful_lite_options[special_links_title_1]', array(
        'label'     => esc_html__( 'Title 1', 'graceful-lite' ),
        'section'   => 'graceful_lite_special_links',
        'type'      => 'text',
        'priority'  => 9
    ) );

    $wp_customize->add_setting( 'graceful_lite_options[special_links_url_1]', array(
        'default'    => graceful_lite_options( 'special_links_url_1' ),
        'type'       => 'option',
        'transport'  => 'refresh',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
    ) );
    $wp_customize->add_control( 'graceful_lite_options[special_links_url_1]', array(
        'label'     => esc_html__( 'URL 1', 'graceful-lite' ),
        'section'   => 'graceful_lite_special_links',
        'type'      => 'text',
        'priority'  => 11
    ) );

    $wp_customize->add_setting( 'graceful_lite_options[special_links_image_1]', array(
        'default'   => '',
        'type'      => 'option',
        'transport' => 'refresh',
        'sanitize_callback' => 'graceful_sanitize_number_absint'
    ) );
    $wp_customize->add_control(
        new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_lite_options[special_links_image_1]', array(
            'label'         => esc_html__( 'Image 1', 'graceful-lite' ),
            'section'       => 'graceful_lite_special_links',
            'flex_width'    => false,
            'flex_height'   => false,
            'width'         => 600,
            'height'        => 340,
            'priority'      => 13
        )
    ) );

    // Special Links 2
    $wp_customize->add_setting( 'graceful_lite_options[special_links_title_2]', array(
        'default'    => graceful_lite_options( 'special_links_title_2' ),
        'type'       => 'option',
        'transport'  => 'refresh',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ) );
    $wp_customize->add_control( 'graceful_lite_options[special_links_title_2]', array(
        'label'     => esc_html__( 'Title 2', 'graceful-lite' ),
        'section'   => 'graceful_lite_special_links',
        'type'      => 'text',
        'priority'  => 15
    ) );

    $wp_customize->add_setting( 'graceful_lite_options[special_links_url_2]', array(
        'default'    => graceful_lite_options( 'special_links_url_2' ),
        'type'       => 'option',
        'transport'  => 'refresh',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
    ) );
    $wp_customize->add_control( 'graceful_lite_options[special_links_url_2]', array(
        'label'     => esc_html__( 'URL 2', 'graceful-lite' ),
        'section'   => 'graceful_lite_special_links',
        'type'      => 'text',
        'priority'  => 17
    ) );

    $wp_customize->add_setting( 'graceful_lite_options[special_links_image_2]', array(
        'default'   => '',
        'type'      => 'option',
        'transport' => 'refresh',
        'sanitize_callback' => 'graceful_sanitize_number_absint'
    ) );
    $wp_customize->add_control(
        new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_lite_options[special_links_image_2]', array(
            'label'         => esc_html__( 'Image 2', 'graceful-lite' ),
            'section'       => 'graceful_lite_special_links',
            'flex_width'    => false,
            'flex_height'   => false,
            'width'         => 600,
            'height'        => 340,
            'priority'      => 19
        )
    ) );

    // Special Links 3
    $wp_customize->add_setting( 'graceful_lite_options[special_links_title_3]', array(
        'default'    => graceful_lite_options( 'special_links_title_3' ),
        'type'       => 'option',
        'transport'  => 'refresh',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'sanitize_text_field'
    ) );
    $wp_customize->add_control( 'graceful_lite_options[special_links_title_3]', array(
        'label'     => esc_html__( 'Title 3', 'graceful-lite' ),
        'section'   => 'graceful_lite_special_links',
        'type'      => 'text',
        'priority'  => 21
    ) );

    $wp_customize->add_setting( 'graceful_lite_options[special_links_url_3]', array(
        'default'    => graceful_lite_options( 'special_links_url_3' ),
        'type'       => 'option',
        'transport'  => 'refresh',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'esc_url_raw'
    ) );
    $wp_customize->add_control( 'graceful_lite_options[special_links_url_3]', array(
        'label'     => esc_html__( 'URL 3', 'graceful-lite' ),
        'section'   => 'graceful_lite_special_links',
        'type'      => 'text',
        'priority'  => 23
    ) );

    $wp_customize->add_setting( 'graceful_lite_options[special_links_image_3]', array(
        'default'   => '',
        'type'      => 'option',
        'transport' => 'refresh',
        'sanitize_callback' => 'graceful_sanitize_number_absint'
    ) );
    $wp_customize->add_control(
        new WP_Customize_Cropped_Image_Control( $wp_customize, 'graceful_lite_options[special_links_image_3]', array(
            'label'         => esc_html__( 'Image 3', 'graceful-lite' ),
            'section'       => 'graceful_lite_special_links',
            'flex_width'    => false,
            'flex_height'   => false,
            'width'         => 600,
            'height'        => 340,
            'priority'      => 25
        )
    ) );

    // Special Links Layout Width
    $boxed_width_special_links = array(
        'full' => esc_html__( 'Full', 'graceful-lite' ),
        'wrapped' => esc_html__( 'Boxed', 'graceful-lite' ),
    );

    $wp_customize->add_setting( 'graceful_lite_options[special_links_width]', array(
        'default'    => graceful_lite_options( 'special_links_width' ),
        'type'       => 'option',
        'transport'  => 'refresh',
        'capability' => 'edit_theme_options',
        'sanitize_callback' => 'graceful_sanitize_select'
    ) );
    $wp_customize->add_control( 'graceful_lite_options[special_links_width]', array(
        'label'         => esc_html__( 'Special Links Width', 'graceful-lite' ),
        'section'       => 'graceful_basic',
        'type'          => 'select',
        'choices'       => $boxed_width_special_links,
        'priority'      => 28
    ) );

}
add_action( 'customize_register', 'graceful_lite_customize_register', 99 );

// Sanitize number absint
function graceful_sanitize_number_absint( $number, $setting ) {

    // ensure $number is an absolute integer
    $number = absint( $number );

    // return default if not integer
    return ( $number ? $number : $setting->default );

}

// Enqueue customizer styles
function graceful_lite_customizer_css() {
    wp_enqueue_style( 'graceful-customize-style', get_theme_file_uri( '/css/customize-ui.css' ) );
}
add_action( 'customize_controls_enqueue_scripts', 'graceful_lite_customizer_css' );

// Graceful lite default options
function graceful_lite_options( $controls ) {

    $graceful_lite_defaults = array(
        'blog_grid_excerpt_length' => '30',
        'special_links_show' => false,
        'special_links_window' => true,
        'special_links_width' => 'full',
        'special_links_title_1' => '',
        'special_links_url_1' => '',
        'special_links_image_1' => '',
        'special_links_title_2' => '',
        'special_links_url_2' => '',
        'special_links_image_2' => '',
        'special_links_title_3' => '',
        'special_links_url_3' => '',
        'special_links_image_3' => '',
    );

    // merge defaults and options
    $graceful_lite_defaults = wp_parse_args( get_option( 'graceful_lite_options' ), $graceful_lite_defaults );

    // return control
    return $graceful_lite_defaults[ $controls ];

}


// ----------------------------------------------------------------------------------
//  New Font
// ----------------------------------------------------------------------------------
function graceful_lite_enqueue_assets()
{
    // Include the file.
    require_once get_theme_file_path('webfont-loader/wptt-webfont-loader.php');
    // Load the webfont.
    wp_enqueue_style(
        'minimalist-stories-fonts',
        wptt_get_webfont_url('https://fonts.googleapis.com/css2?family=Lato:wght@400;700&display=auto'),
        array(),
        '1.0'
    );
}
add_action('wp_enqueue_scripts', 'graceful_lite_enqueue_assets');


// ----------------------------------------------------------------------------------
//  New Thumbnail Size
// ----------------------------------------------------------------------------------
if ( function_exists( 'add_image_size' ) ) {
    // new column thumbnail size
    add_image_size( 'graceful-post-column-thumbnail', 700, 680, true );
}
