/**
 * Glow Slider JavaScript
 * 
 * Handles carousel initialization and navigation behavior
 * Uses Owl Carousel library from parent theme
 * 
 * @package Graceful Glow Blog
 * @since 1.0.0
 */

jQuery(document).ready(function($) {
	'use strict';
	
	/**
	 * Initialize Glow Slider
	 */
	function initGlowSlider() {
		// Check if Owl Carousel is available
		if (typeof $.fn.owlCarousel === 'undefined') {
			console.warn('Glow Slider: Owl Carousel library not loaded');
			return;
		}
		
		var $carousel = $('.glow-slider-container .owl-carousel');
		
		if ($carousel.length === 0) {
			console.warn('Glow Slider: Carousel element not found');
			return;
		}
		
		// Initialize Owl Carousel
		$carousel.owlCarousel({
			items: 1,
			loop: true,
			autoplay: true,
			autoplayTimeout: 6000,
			autoplayHoverPause: true,
			nav: false,
			dots: true,
			dotsContainer: '.glow-slider-dots',
			animateOut: 'fadeOut',
			animateIn: 'fadeIn',
			smartSpeed: 800,
			responsive: {
				0: {
					items: 1,
					nav: false,
					dots: true
				},
				768: {
					items: 1,
					nav: false,
					dots: true
				},
				1024: {
					items: 1,
					nav: false,
					dots: true
				}
			},
			mouseDrag: true,
			touchDrag: true,
			pullDrag: true,
			freeDrag: false,
			stagePadding: 0,
			autoWidth: false,
			startPosition: 0,
			rtl: false,
			center: false,
			lazyLoad: false,
			autoHeight: false
		});
	}
	
	/**
	 * Setup Custom Navigation
	 */
	function setupNavigation() {
		var $carousel = $('.glow-slider-container .owl-carousel');
		
		if (typeof $.fn.owlCarousel === 'undefined' || $carousel.length === 0) {
			console.warn('Glow Slider: Cannot setup navigation - carousel not available');
			return;
		}
		
		// Previous button
		$('.glow-slider-nav.prev').on('click', function(e) {
			e.preventDefault();
			e.stopPropagation();
			$carousel.trigger('prev.owl.carousel');
		});
		
		// Next button
		$('.glow-slider-nav.next').on('click', function(e) {
			e.preventDefault();
			e.stopPropagation();
			$carousel.trigger('next.owl.carousel');
		});
		
		// Keyboard navigation
		$(document).on('keydown', function(e) {
			if ($('.glow-slider-container').is(':focus-within')) {
				switch(e.which) {
					case 37: // Left arrow
						e.preventDefault();
						$carousel.trigger('prev.owl.carousel');
						break;
					case 39: // Right arrow
						e.preventDefault();
						$carousel.trigger('next.owl.carousel');
						break;
				}
			}
		});
	}
	
	// Initialize
	initGlowSlider();
	setupNavigation();
});
