<?php
/**
 * Template part for displaying front page introduction.
 *
 * @package Full News
 */

// Banner Section.
$banner_section = get_theme_mod( 'indepth_news_banner_section_enable', false );

if ( false === $banner_section ) {
	return;
}

$grid_post_content_ids   = array();
$grid_posts_content_type = get_theme_mod( 'full_news_banner_news_content_type', 'post' );

if ( $grid_posts_content_type === 'post' ) {

	for ( $i = 1; $i <= 5; $i++ ) {
		$grid_post_content_ids[] = get_theme_mod( 'full_news_banner_news_post_' . $i );
	}

	$grid_posts_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 5 ),
		'ignore_sticky_posts' => true,
	);

	if ( ! empty( array_filter( $grid_post_content_ids ) ) ) {
		$grid_posts_args['post__in'] = array_filter( $grid_post_content_ids );
		$grid_posts_args['orderby']  = 'post__in';
	} else {
		$grid_posts_args['orderby'] = 'date';
	}
} else {
	$cat_content_id  = get_theme_mod( 'full_news_banner_news_category' );
	$grid_posts_args = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 5 ),
	);
}
?>

<div id="indepth_news_banner_section" class="main-banner-section style-2 adore-navigation">
	<div class="theme-wrapper">
		<div class="main-banner-section-wrapper">
			
			<div class="banner-grid-outer">
				<div class="banner-grid-wrapper">
					<?php
					$grid_posts_query = new WP_Query( $grid_posts_args );
					if ( $grid_posts_query->have_posts() ) {
						$i = 1;
						while ( $grid_posts_query->have_posts() ) :
							$grid_posts_query->the_post();
							?>
							<div class="post-item post-grid">
								<div class="post-item-image">
									<a href="<?php the_permalink(); ?>">
										<?php the_post_thumbnail(); ?>							
									</a>
								</div>
								<div class="post-item-content">
									<div class="entry-cat no-bg">
										<?php the_category( '', '', get_the_ID() ); ?>						
									</div>
									<h3 class="entry-title">
										<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
									</h3>  
									<?php if ( $i === 1 ) { ?>
										<div class="post-exerpt">
											<?php
											$content = get_the_content();
											$content = strip_shortcodes( $content ); // Remove shortcodes, including image captions
											$content = preg_replace( '/<img(.*?)alt=[\'"](.*?)[\'"](.*?)>/i', '', $content ); // Remove image tags with alt attributes
											$content = wp_kses_post( wp_trim_words( $content, 35 ) );
											?>
											<p><?php echo $content; ?></p>
										</div>
									<?php } ?>
									<ul class="entry-meta">
										<li class="post-author"> <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>"><span class="far fa-user"></span><?php echo esc_html( get_the_author() ); ?></a></li>
										<li class="post-date"> <span class="far fa-calendar-alt"></span><?php echo esc_html( get_the_date() ); ?></li>
										<li class="post-comment"> <span class="far fa-comment"></span><?php echo absint( get_comments_number( get_the_ID() ) ); ?></li>
									</ul>
								</div>
							</div>
							<?php
							$i++;
						endwhile;
						wp_reset_postdata();
					}
					?>
				</div>
			</div>

		</div>
	</div>
</div>