<?php

// upgrade to pro.
require get_theme_file_path() . '/inc/upgrade-to-pro/class-customize.php';

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */
function full_news_customize_register( $wp_customize ) {

	if ( class_exists( 'WP_Customize_Control' ) ) {

		class Full_News_Sub_Section_Heading_Custom_Control extends WP_Customize_Control {

			// The type of control being rendered.
			public $type = 'sub_section_heading';

			// Render the control in the customizer.

			public function render_content() {

				?>
				<div class="sub-section-heading-control">
					<?php if ( ! empty( $this->label ) ) { ?>
						<h4 class="customize-control-title">
							<?php echo esc_html( $this->label ); ?>
						</h4>
					<?php } ?>

				</div>
				<?php
			}
		}

	}

	// Banner.
	require get_theme_file_path() . '/inc/customizer/banner.php';

}
add_action( 'customize_register', 'full_news_customize_register' );

function full_news_custom_control_scripts() {
	wp_enqueue_style( 'full-news-customize-style', get_stylesheet_directory_uri() . '/assets/css/customize-controls.min.css', array( 'indepth-news-customize-style' ), '1.0.0', 'all' );
}
add_action( 'customize_controls_enqueue_scripts', 'full_news_custom_control_scripts' );
