<?php
/**
 * Adore Themes Customizer
 *
 * @package Full News
 *
 * Banner Section
 */

// Banner News Sub Heading.
$wp_customize->add_setting(
	'full_news_banner_news_sub_heading',
	array(
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	new Full_News_Sub_Section_Heading_Custom_Control(
		$wp_customize,
		'full_news_banner_news_sub_heading',
		array(
			'label'           => esc_html__( 'Banner News Section', 'full-news' ),
			'settings'        => 'full_news_banner_news_sub_heading',
			'section'         => 'indepth_news_banner_section',
			'active_callback' => 'indepth_news_if_banner_enabled',
			'priority'        => 140
		)
	)
);

// banner news content type settings.
$wp_customize->add_setting(
	'full_news_banner_news_content_type',
	array(
		'default'           => 'post',
		'sanitize_callback' => 'indepth_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'full_news_banner_news_content_type',
	array(
		'label'           => esc_html__( 'Banner News Content type:', 'full-news' ),
		'description'     => esc_html__( 'Choose where you want to render the content from.', 'full-news' ),
		'section'         => 'indepth_news_banner_section',
		'settings'        => 'full_news_banner_news_content_type',
		'type'            => 'select',
		'active_callback' => 'indepth_news_if_banner_enabled',
		'priority'        => 150,
		'choices'         => array(
			'post'     => esc_html__( 'Post', 'full-news' ),
			'category' => esc_html__( 'Category', 'full-news' ),
		),
	)
);

for ( $i = 1; $i <= 5; $i++ ) {
	// Banner News post setting.
	$wp_customize->add_setting(
		'full_news_banner_news_post_' . $i,
		array(
			'sanitize_callback' => 'indepth_news_sanitize_dropdown_pages',
		)
	);

	$wp_customize->add_control(
		'full_news_banner_news_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Post %d', 'full-news' ), $i ),
			'section'         => 'indepth_news_banner_section',
			'type'            => 'select',
			'choices'         => indepth_news_get_post_choices(),
			'active_callback' => 'full_news_banner_news_content_type_post_enabled',
			'priority'        => 160
		)
	);

}

// Banner News category setting.
$wp_customize->add_setting(
	'full_news_banner_news_category',
	array(
		'sanitize_callback' => 'full_news_sanitize_select',
	)
);

$wp_customize->add_control(
	'full_news_banner_news_category',
	array(
		'label'           => esc_html__( 'Category', 'full-news' ),
		'section'         => 'indepth_news_banner_section',
		'type'            => 'select',
		'choices'         => indepth_news_get_post_cat_choices(),
		'active_callback' => 'full_news_banner_news_content_type_category_enabled',
		'priority'        => 170
	)
);

/*========================Active Callback==============================*/
function full_news_banner_news_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'full_news_banner_news_content_type' )->value();
	return indepth_news_if_banner_enabled( $control ) && ( 'post' === $content_type );
}
function full_news_banner_news_content_type_category_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'full_news_banner_news_content_type' )->value();
	return indepth_news_if_banner_enabled( $control ) && ( 'category' === $content_type );
}

