<?php
/**
 * Full News functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Full News
 */

add_theme_support( 'title-tag' );

add_theme_support( 'automatic-feed-links' );

add_theme_support( 'register_block_style' );

add_theme_support( 'register_block_pattern' );

add_theme_support( 'responsive-embeds' );

add_theme_support( 'wp-block-styles' );

add_theme_support( 'align-wide' );

add_theme_support(
	'html5',
	array(
		'search-form',
		'comment-form',
		'comment-list',
		'gallery',
		'caption',
		'style',
		'script',
	)
);

add_theme_support(
	'custom-logo',
	array(
		'height'      => 250,
		'width'       => 250,
		'flex-width'  => true,
		'flex-height' => true,
	)
);

if ( ! function_exists( 'full_news_setup' ) ) :
	function full_news_setup() {
		/*
		* Make child theme available for translation.
		* Translations can be filed in the /languages/ directory.
		*/
		load_child_theme_textdomain( 'full-news', get_stylesheet_directory() . '/languages' );
	}
endif;
add_action( 'after_setup_theme', 'full_news_setup' );

if ( ! function_exists( 'full_news_enqueue_styles' ) ) :
	/**
	 * Enqueue scripts and styles.
	 */
	function full_news_enqueue_styles() {
		$parenthandle = 'indepth-news-style';
		$theme        = wp_get_theme();

		wp_enqueue_style(
			$parenthandle,
			get_template_directory_uri() . '/style.css',
			array(
				'indepth-news-fonts-style',
				'indepth-news-slick-style',
				'indepth-news-fontawesome-style',
				'indepth-news-blocks-style',
			),
			$theme->parent()->get( 'Version' )
		);

		wp_enqueue_style(
			'full-news-style',
			get_stylesheet_uri(),
			array( $parenthandle ),
			$theme->get( 'Version' )
		);

		// Custom script.
		wp_enqueue_script( 'full-news-custom-script', get_stylesheet_directory_uri() . '/assets/js/custom.min.js', array( 'jquery', 'indepth-news-custom-script' ), true );

	}

endif;

add_action( 'wp_enqueue_scripts', 'full_news_enqueue_styles' );

function full_news_body_classes( $classes ) {

	// added class for sticky header.
	$classes[]    = 'header-fixed';

	return $classes;
}
add_filter( 'body_class', 'full_news_body_classes' );

// Customizer.
require get_theme_file_path() . '/inc/customizer/customizer.php';

// Widget.
require get_theme_file_path() . '/inc/widgets/widgets.php';

/**
 * Set up the WordPress core custom header feature.
 *
 * @uses full_news_header_style()
 */
/**
 * Set up the WordPress core custom header feature.
 *
 * @uses full_news_header_style()
 */
function full_news_custom_header_setup() {
	add_theme_support(
		'custom-header',
		apply_filters(
			'indepth_news_custom_header_args',
			array(
				'default-image'      => '',
				'default-text-color' => 'df2e38',
				'width'              => 1000,
				'height'             => 250,
				'flex-height'        => true,
				'wp-head-callback'   => 'indepth_news_header_style',
			)
		)
	);
}
add_action( 'after_setup_theme', 'full_news_custom_header_setup' );

// One Click Demo Import after import setup.
if ( class_exists( 'OCDI_Plugin' ) ) {
	require get_theme_file_path() . '/inc/demo-import.php';
}

function full_news_header_text_style() {

	?>
	<style type="text/css">

		/* Site title */
		.site-title a{
			color: #<?php echo esc_attr( get_header_textcolor() ); ?>;
		}
		/* End Site title */

		:root {
			--body-bg-color: #<?php echo esc_attr( get_background_color() ); ?>;
		}

	</style>

	<?php
}
add_action( 'wp_head', 'full_news_header_text_style' );

function full_news_load_custom_wp_admin_style() {
	?>
	<style type="text/css">
		.ocdi p.demo-data-download-link {
			display: none !important;
		}
	</style>
	<?php
}
add_action( 'admin_enqueue_scripts', 'full_news_load_custom_wp_admin_style' );

// Style for demo data download link.
function full_news_admin_panel_demo_data_download_link() {
	?>
	<style type="text/css">
		p.full-news-demo-data {
			font-size: 16px;
			font-weight: 700;
			display: inline-block;
			border: 0.5px solid #dfdfdf;
			padding: 8px;
			background: #ffff;
		}
	</style>
	<?php
}
add_action( 'admin_enqueue_scripts', 'full_news_admin_panel_demo_data_download_link' );