<?php
/**
 * Define Theme Version
 */
define( 'FLEXI_MART_THEME_VERSION', '11.7' );

function flexi_mart_css() {
	$parent_style = 'flossy-parent-style';
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' );
	
	wp_enqueue_style('flexi-mart-default',get_stylesheet_directory_uri() .'/assets/css/default.css');
	wp_dequeue_style('flossy-default');
	
	wp_enqueue_script('flexi-mart-custom', get_stylesheet_directory_uri() . '/assets/js/custom.js', array('jquery'), false, true);
	wp_dequeue_script('flossy-custom-js');
}
add_action( 'wp_enqueue_scripts', 'flexi_mart_css',999);


require get_stylesheet_directory() . '/inc/customizer/customizer-options/flexi-mart-pro.php';

/**
 * Import Settings From Parent Theme
 *
 */
function flexi_mart_parent_theme_options() {
	$flossy_mods = get_option( 'theme_mods_flossy' );
	if ( ! empty( $flossy_mods ) ) {
		foreach ( $flossy_mods as $flossy_mod_k => $flossy_mod_v ) {
			set_theme_mod( $flossy_mod_k, $flossy_mod_v );
		}
	}
}
add_action( 'after_switch_theme', 'flexi_mart_parent_theme_options' );

/****
* This Theme supports
*/
add_theme_support( 'post-thumbnails' );
add_theme_support( 'title-tag' );
add_theme_support( 'automatic-feed-links' );
add_theme_support( 'custom-background' );
add_theme_support( 'custom-logo' );
add_theme_support( 'wp-block-styles' );
add_theme_support( 'responsive-embeds' );
add_theme_support( 'align-wide' );
add_theme_support( 'register_block_style' );
add_theme_support( 'register_block_pattern' );
add_theme_support( 'add_editor_style()' );
add_theme_support( 'html5', array('search-form','comment-form','comment-list','gallery','caption'));