<!DOCTYPE html>
<!--[if IE 6]>
<html id="ie6" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 7]>
<html id="ie7" <?php language_attributes(); ?>>
<![endif]-->
<!--[if IE 8]>
<html id="ie8" <?php language_attributes(); ?>>
<![endif]-->
<!--[if !(IE 6) | !(IE 7) | !(IE 8)  ]><!-->
<html <?php language_attributes(); ?>>
<!--<![endif]-->
<head>
<link rel="profile" href="http://gmpg.org/xfn/11" />
<meta http-equiv="Content-Type" content="<?php bloginfo('html_type'); ?>; charset=<?php bloginfo('charset'); ?>" />
<title><?php wp_title( '|', true, 'right' ); ?></title>
<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>" />
	<!--[if lt IE 9]>
	<script src="<?php echo get_template_directory_uri(); ?>/js/html5.js"></script>
	<![endif]-->
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<?php wp_head(); ?>
</head>
<?php flush(); ?>

<body <?php body_class(); ?>>
			<nav role="navigation">
			
			<div class="navbar navbar-static-top">
			<div class="navbar-inner">
			<div class="container">
			<h1><a class="brand" title="<?php bloginfo('description'); ?>" href="<?php echo home_url(); ?>"><?php bloginfo('name'); ?></a></h1>
			<p class="navbar-text pull-right">
			<!-- /.social links -->
			</p>
			</div>
			</div>
			</div>
			
			<!-- /top right navbar -->
			
			</nav>
	
			<div class="container">
				<div class="masthead">
			<?php if (has_nav_menu('top-right') ) : ?>
			<?php
			wp_nav_menu( array(
			'theme_location' => 'top-right',
			'depth' => 2,
			'container' => false,
			'menu_class' => 'nav nav-pills pull-right',
			//Process nav menu using our custom nav walker
			'walker' => new wp_bootstrap_navwalker())
			);
			?>
			<?php else : ?>
			<?php wp_nav_menu( array( 'theme_location' => 'top-right', 'depth' => 1, 'menu_class' => 'nav-menu' ) ); ?>
			<?php endif; ?>
<img src="<?php header_image(); ?>" height="<?php echo get_custom_header()->height; ?>" width="<?php echo get_custom_header()->width; ?>" alt="" />
				</div>
				<div class="clear"></div>
				
<!-- /primary navbar -->

		
       
					<?php if (has_nav_menu('primary') ) : ?>
					<nav role="navigation">
				<div class="navbar">
				<div class="navbar-inner">
					<div class="container">
					 <button type="button" class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					<span class="icon-bar"></span>
					</button>
					<div class="nav-collapse collapse">
					<?php
					wp_nav_menu( array(
					'theme_location' => 'primary',
					'depth' => 2,
					'container' => false,
					'fallback_cb' => 'wp_page_menu',
					'menu_class' => 'nav',
					//Process nav menu using our custom nav walker
					'walker' => new wp_bootstrap_navwalker())
					);
					?>
					</div>
					</div>
				</div>
				</div><!-- /.navbar -->
				</nav>
				
					<?php else : ?>
					<div id="navbar" class="navbar">
					<nav id="site-navigation" class="navigation main-navigation" role="navigation">
					<h3 class="menu-toggle"><?php _e( 'Menu', 'flatportfolio' ); ?></h3>
					<?php wp_nav_menu( array( 'theme_location' => 'primary', 'depth' => 0, 'menu_class' => 'nav-menu' ) ); ?>
					</nav><!-- #site-navigation -->
					</div><!-- #navbar -->
					<?php endif; ?>
				
			</div>
			<!-- /main layout divs -->
			
	<div id="wrap">
	
		<div class="wrapperbig">
		
			<div id="skip">
				<a href="#content">Skip to Main Content</a>
			</div>
			
	<div class="container">		

		
	<div id="wrapcontainer">
	
	<!-- /content divs start -->
	
	<div id="container" role="main">

		<?php if (is_404() || is_single() || is_page_template('full.php') || is_page_template('gallery.php') || is_page_template('archives.php') || is_page_template('subpages.php') || is_search() || is_tag() || is_date() || is_archive() || is_404() ) : ?>
		<div class="span12">
		<?php else : ?>

		<!-- /side menu -->
		<div class="row-fluid">
		<div class="span3">
	
	<!-- /vertical navbar -->
		<nav role="navigation">
			<?php if (has_nav_menu('vertical') ) : ?>
			<?php
			wp_nav_menu( array(
			'theme_location' => 'vertical',
			'depth' => 1,
			'container' => false,
			'menu_class' => 'nav nav-tabs nav-stacked',
			//Process nav menu using our custom nav walker
			'walker' => new wp_bootstrap_navwalker())
			);
			?>
			<?php else : ?>
			<?php wp_nav_menu( array( 'theme_location' => 'vertical', 'depth' => 1, 'menu' => 'vertical', 'menu_class' => 'nav nav-tabs nav-stacked' ) ); ?>
			<?php endif; ?>
		</nav>
		
		<div class="clear"></div>
			
			<?php dynamic_sidebar('Primary Sidebar') ; ?>
			
			
			
			<ul class="nav nav-tabs nav-stacked">
			<?php wp_list_pages( array('title_li'=>'','include'=>flatportfolio_get_post_top_ancestor_id()) ); ?>
			<?php wp_list_pages( array('title_li'=>'','depth'=>1,'child_of'=>flatportfolio_get_post_top_ancestor_id()) ); ?>
			</ul>
			
			<?php global $post;
			
			$children = wp_list_pages('title_li=&depth=1&child_of='.$post->ID.'&echo=0');
			if ($children && is_page() && $post->post_parent) {
			echo "<h3>In this section</h3><ul class=\"nav nav-pills nav-stacked \">";
			echo $children;
			echo "</ul>";
			}
			
			?>
			
		</div>
		
		<!-- /content -->
	
		<div class="span9">
		
		<?php endif; ?>
		
	<a name="content" title="Skip to content"></a>

	
	<?php if (is_404() || is_single() || is_page_template('full.php') || is_page_template('gallery.php') || is_page_template('archives.php') || is_page_template('subpages.php') || is_search() || is_tag() || is_date() || is_archive() ) : ?>
	<div class="full-width">	
	<?php else : ?>
	<div class="post">
	<?php endif; ?>
		