<?php
function flatportfolio_widgets_init() {

register_sidebar( array(

'name'=>'Primary Sidebar',

'id'   => 'primary_sidebar',

'description'   => 'Default Left Side Bar',

'before_widget' => '<div class="well">',

'after_widget'  => '</div>',

'before_title'  => '<h4>',

'after_title'   => '</h4>'

));
register_sidebar( array(

'name'=>'Footer Area1',

'id'   => 'footer_area1',

'description'   => 'Footer widget1',

'before_widget' => '<div class="well">',

'after_widget'  => '</div>',

'before_title'  => '<h4>',

'after_title'   => '</h4>'

));
register_sidebar( array(

'name'=>'Footer Area2',

'id'   => 'footer_area2',

'description'   => 'Footer widget2',

'before_widget' => '<div class="well">',

'after_widget'  => '</div>',

'before_title'  => '<h4>',

'after_title'   => '</h4>'

));
register_sidebar( array(

'name'=>'Footer Area3',

'id'   => 'footer_area3',

'description'   => 'Footer widget3',

'before_widget' => '<div class="well">',

'after_widget'  => '</div>',

'before_title'  => '<h4>',

'after_title'   => '</h4>'

));
register_sidebar( array(

'name'=>'Footer Area Home 1',

'id'   => 'footer_area_home1',

'description'   => 'Home Footer widget1',

'before_widget' => '<div class="well">',

'after_widget'  => '</div>',

'before_title'  => '<h4>',

'after_title'   => '</h4>'

));
register_sidebar( array(

'name'=>'Footer Area Home 2',

'id'   => 'footer_area_home2',

'description'   => 'Home Footer widget2',

'before_widget' => '<div class="well">',

'after_widget'  => '</div>',

'before_title'  => '<h4>',

'after_title'   => '</h4>'

));
}
add_action( 'widgets_init', 'flatportfolio_widgets_init' );

/**
* Sets up theme defaults and registers support for various WordPress features.
*
* Declare textdomain for this child theme.
* Translations can be filed in the /languages/ directory.
*/
function flatportfolio_setup() {
load_child_theme_textdomain( 'flatportfolio', get_stylesheet_directory() . '/languages' );

// custom header
$args = array(
'flex-width'    => true,
'width'         => 1170,
'flex-height'    => true,
);
add_theme_support( 'custom-header', $args );

// Custom background image
add_theme_support( 'custom-background' );

// Register Custom Navigation Walker
require_once('wp_bootstrap_navwalker.php');

// This theme uses wp_nav_menu() in 3 locations.
register_nav_menus( array(
'top-right' => __( 'Top Right Navigation', 'flatportfolio' ),
'primary' => __( 'Primary Navigation', 'flatportfolio' ),
'vertical' => __( 'Vertical Navigation', 'flatportfolio' )
) );
}
add_action( 'after_setup_theme', 'flatportfolio_setup' );

// Unregister some of the Default Theme Sidebars
function flatportfolio_remove_some_widgets(){
unregister_sidebar( 'sidebar-1' );
unregister_sidebar( 'sidebar-2' );
}
add_action( 'widgets_init', 'flatportfolio_remove_some_widgets', 11 );

// thickbox
function flatportfolio_thickbox_enqueue_scripts() {
wp_enqueue_script('thickbox');
wp_enqueue_style('thickbox');
}
add_action('wp_enqueue_scripts', 'flatportfolio_thickbox_enqueue_scripts');

// thickbox class to images
function flatportfolio_add_thickbox_class_to_image_links($html, $attachment_id, $attachment) {
$linkptrn = "/<a[^>]*>/";
$found = preg_match($linkptrn, $html, $a_elem);

// If no link, do nothing
if($found <= 0) return $html;

$a_elem = $a_elem[0];

// Check to see if the link is to an uploaded image
$uploads = wp_upload_dir();
$upload_path = basename($uploads['baseurl']);
$is_attachment_link = strstr($a_elem, $upload_path);

// If link is to external resource, do nothing
if($is_attachment_link === FALSE) return $html;

if(strstr($a_elem, "class=\"") !== FALSE){ // If link already has class defined inject it to attribute
$a_elem_new = str_replace("class=\"", "class=\"thickbox ", $a_elem);
$html = str_replace($a_elem, $a_elem_new, $html);
}else{ // If no class defined, just add class attribute
$html = str_replace("<a ", "<a class=\"thickbox\" ", $html);
}

return $html;
}

add_filter('image_send_to_editor', 'flatportfolio_add_thickbox_class_to_image_links', 10, 3);


// list subpages
if(!function_exists('flatportfolio_get_post_top_ancestor_id')){
/**
* Gets the id of the topmost ancestor of the current page. Returns the current
* page's id if there is no parent.
*
* @uses object $post
* @return int
*/
function flatportfolio_get_post_top_ancestor_id(){
global $post;

if($post->post_parent){
$ancestors = array_reverse(get_post_ancestors($post->ID));
return $ancestors[0];
}

return $post->ID;
}}

// Stylesheets
function flatportfolio_styles() {

// Register stylesheets
wp_register_style( 'bootstrap', get_stylesheet_directory_uri() . '/css/bootstrap.min.css', array(), '2.3.2', 'all' );
wp_register_style( 'bootstrap-responsive', get_stylesheet_directory_uri() . '/css/bootstrap-responsive.min.css', array(), '2.3.2', 'all' );
wp_register_style( 'flatportfolio-main', get_stylesheet_directory_uri() . '/style.css', array(), '2.2.5', 'all' );

// Enqueue stylesheets
wp_enqueue_style( 'bootstrap' );
wp_enqueue_style( 'bootstrap-responsive' );
wp_enqueue_style( 'flatportfolio-main' );
}
add_action( 'wp_enqueue_scripts', 'flatportfolio_styles' );


function flatportfolio_scripts_styles() {

// Loads Bootstrap JavaScript file.
wp_enqueue_script( 'flatportfolio-bootstrap', get_stylesheet_directory_uri() . '/js/bootstrap.min.js', array( 'jquery' ), '2.3.2', true );
}
add_action( 'wp_enqueue_scripts', 'flatportfolio_scripts_styles' );

?>