<?php
/**
 * Custom functions that act independently of the theme templates.
 *
 * Eventually, some of the functionality here could be replaced by core features.
 *
 * @package Figure/Ground
 */

/**
 * Get our wp_nav_menu() fallback, wp_page_menu(), to show a home link.
 */
function figureground_page_menu_args( $args ) {
	$args['show_home'] = true;
	return $args;
}
add_filter( 'wp_page_menu_args', 'figureground_page_menu_args' );

/**
 * Adds custom classes to the array of body classes.
 */
function figureground_body_classes( $classes ) {
	// Adds a class of group-blog to blogs with more than 1 published author.
	if ( is_multi_author() ) {
		$classes[] = 'group-blog';
	}

	// Add support for responsive embeds.
	$classes[] = 'wp-embed-responsive';

	return $classes;
}
add_filter( 'body_class', 'figureground_body_classes' );

/**
 * Adds custom classes to the array of post classes.
 */
function figureground_post_classes( $classes ) {
	// Adds a class of formatted-post to post-formatted posts.
	if ( has_post_format() ) {
		$classes[] = 'formatted-post';
	}

	return $classes;
}
add_filter( 'post_class', 'figureground_post_classes' );
