<?php
if ( ! get_theme_mod( 'right_news_enable_banner_section', false ) ) {
	return;
}

$content_ids = array();
$banner_type = get_theme_mod( 'right_news_banner_content_type', 'category' );

if ( $banner_type === 'post' ) {
	for ( $i = 1; $i <= 10; $i++ ) {
		$content_ids[] = get_theme_mod( 'right_news_banner_content_post_' . $i );
	}
	$banner_args = array(
		'post_type'           => 'post',
		'posts_per_page'      => absint( 10 ),
		'ignore_sticky_posts' => true,
	);
	if ( ! empty( array_filter( $content_ids ) ) ) {
		$banner_args['post__in'] = array_filter( $content_ids );
		$banner_args['orderby']  = 'post__in';
	} else {
		$banner_args['orderby'] = 'date';
	}
} else {
	$cat_content_id = get_theme_mod( 'right_news_banner_content_category' );
	$banner_args    = array(
		'cat'            => $cat_content_id,
		'posts_per_page' => absint( 10 ),
	);
}

$banner_args = apply_filters( 'right_news_banner_section_args', $banner_args );

right_news_render_banner_section( $banner_args );

/**
 * Render Banner Section.
 */
function right_news_render_banner_section( $banner_args ) {

	$query = new WP_Query( $banner_args );
	if ( $query->have_posts() ) {
		?>
		<section id="right_news_banner_section" class="banner-section banner-section-style-3 banner-grid-slider">
			<?php
			if ( is_customize_preview() ) :
				right_news_section_link( 'right_news_banner_section' );
			endif;
			?>
			<div class="ascendoor-wrapper">
				<div class="banner-section-wrapper">
					<div class="banner-slider magazine-carousel-slider-navigation">
						<?php
						while ( $query->have_posts() ) :
							$query->the_post();
							?>
							<div class="mag-post-single banner-gird-single has-image tile-design">
								<div class="mag-post-img">
									<a href="<?php the_permalink(); ?>">
										<?php the_post_thumbnail( 'full' ); ?>
									</a>
								</div>
								<div class="mag-post-detail">
									<div class="mag-post-category with-background">
										<?php right_news_categories_list( true ); ?>
									</div>
									<h3 class="mag-post-title">
										<a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
									</h3>
									<div class="mag-post-meta">
										<?php
										right_news_posted_by();
										right_news_posted_on();
										?>
									</div>
								</div>
							</div>
							<?php
						endwhile;
						wp_reset_postdata();
						?>
					</div>
					<div class="banner-slider_dots">
						<?php
						while ( $query->have_posts() ) :
							$query->the_post();
							?>
							<div class="slider_navigators-wrraper">
								<div class="slider_navigators"></div>
							</div>
							<?php
						endwhile;
						wp_reset_postdata();
						?>
					</div>
				</div>
			</div>
		</section>
		<?php
	}
}
