<?php
/**
 * Theme Customizer
 *
 * @package Fair_News
 */

function fair_news_customize_register( $wp_customize ) {

	// Upsell Section.
	$wp_customize->add_section(
		new Fair_News_Upsell_Section(
			$wp_customize,
			'upsell_sections',
			array(
				'title'            => __( 'Fair News Pro', 'fair-news' ),
				'button_text'      => __( 'Buy Pro', 'fair-news' ),
				'url'              => 'https://ascendoor.com/themes/fair-news-pro/',
				'background_color' => '#ef1a1a',
				'text_color'       => '#fff',
				'priority'         => 0,
			)
		)
	);

}
add_action( 'customize_register', 'fair_news_customize_register' );

function fair_news_custom_control_scripts() {
	wp_enqueue_style( 'fair-news-custom-controls-css', get_stylesheet_directory_uri() . '/assets/css/custom-controls.min.css', array( 'right-news-custom-controls-css' ), '1.0', 'all' );
	wp_enqueue_script( 'fair-news-custom-controls-js', get_stylesheet_directory_uri() . '/assets/js/custom-controls.min.js', array( 'right-news-custom-controls-js', 'jquery', 'jquery-ui-core' ), '1.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'fair_news_custom_control_scripts' );
