<?php
/**
 * Fair News functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package Fair News
 */

if ( ! function_exists( 'fair_news_setup' ) ) :
	function fair_news_setup() {
		/*
		* Make child theme available for translation.
		* Translations can be filed in the /languages/ directory.
		*/
		load_child_theme_textdomain( 'fair-news', get_stylesheet_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		add_theme_support( 'title-tag' );

		add_theme_support( 'register_block_pattern' );

		add_theme_support( 'register_block_style' );

		add_theme_support( 'wp-block-styles' );

		add_theme_support( 'align-wide' );

		add_theme_support( 'responsive-embeds' );
	}
endif;
add_action( 'after_setup_theme', 'fair_news_setup' );

if ( ! function_exists( 'fair_news_enqueue_styles' ) ) :
	/**
	 * Enqueue scripts and styles.
	 */
	function fair_news_enqueue_styles() {
		$parenthandle = 'right-news-style';
		$theme        = wp_get_theme();

		wp_enqueue_style(
			$parenthandle,
			get_template_directory_uri() . '/style.css',
			array(
				'right-news-slick-style',
				'right-news-fontawesome-style',
				'right-news-google-fonts',
			),
			$theme->parent()->get( 'Version' )
		);

		wp_enqueue_style(
			'fair-news-style',
			get_stylesheet_uri(),
			array( $parenthandle ),
			$theme->get( 'Version' )
		);

	}

endif;

add_action( 'wp_enqueue_scripts', 'fair_news_enqueue_styles' );

function admin_style() {
	?>
	<style type="text/css">
		.ocdi .notice.right-news-demo-data {
			display: none !important;
		}
	</style>
	<?php
}
add_action( 'admin_enqueue_scripts', 'admin_style' );

function fair_news_custom_header_setup() {
	add_theme_support(
		'custom-header',
		apply_filters(
			'right_news_custom_header_args',
			array(
				'default-image'      => '',
				'default-text-color' => 'ef1a1a',
				'width'              => 1000,
				'height'             => 250,
				'flex-height'        => true,
				'wp-head-callback'   => 'right_news_header_style',
			)
		)
	);
}
add_action( 'after_setup_theme', 'fair_news_custom_header_setup' );

require get_theme_file_path() . '/inc/customizer.php';

// Custom Controls
require get_theme_file_path() . '/inc/custom-controls.php';

// Widgets.
require get_theme_file_path() . '/inc/widgets/widgets.php';

/**
 * One Click Demo Import after import setup.
 */
if ( class_exists( 'OCDI_Plugin' ) ) {
	require get_theme_file_path() . '/inc/ocdi.php';
}
