<?php

/**
 * Eyepress lite Theme Customizer
 *
 * @package eyepress
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 */


function eyepress_lite_customize_register($wp_customize)
{

    $wp_customize->remove_control('eyepress_blog_style_control');

    //blog style
    $wp_customize->add_setting('eyepress_lite_blog_style', array(
        'default'       => 'normal',
        'capability'     => 'edit_theme_options',
        'type'           => 'theme_mod',
        'sanitize_callback' => 'eyepress_sanitize_blog_style',
        'transport' => 'refresh',
    ));
    $wp_customize->add_control('eyepress_lite_blog_style', array(
        'label'      => __('Blog style', 'eyepress-lite'),
        'section'    => 'eyepress_blog_section',
        'settings'   => 'eyepress_lite_blog_style',
        'type'       => 'select',
        'choices'    => array(
            'grid' => __('Grid view', 'eyepress-lite'),
            'normal' => __('Normal view', 'eyepress-lite'),
        ),

    ));
    
    // Add dark mode option
    $wp_customize->add_setting('eyepress_lite_dark_mode', array(
        'default'       => 'system',
        'capability'    => 'edit_theme_options',
        'type'          => 'theme_mod',
        'sanitize_callback' => 'eyepress_lite_sanitize_dark_mode',
        'transport'     => 'refresh',
    ));
    
    $wp_customize->add_control('eyepress_lite_dark_mode', array(
        'label'      => __('Dark Mode Preference', 'eyepress-lite'),
        'section'    => 'eyepress_blog_section',
        'settings'   => 'eyepress_lite_dark_mode',
        'type'       => 'select',
        'choices'    => array(
            'system' => __('System Default', 'eyepress-lite'),
            'light'  => __('Light Mode', 'eyepress-lite'),
            'dark'   => __('Dark Mode', 'eyepress-lite'),
        ),
    ));
    
    // Add animation toggle
    $wp_customize->add_setting('eyepress_lite_animations', array(
        'default'       => true,
        'capability'    => 'edit_theme_options',
        'type'          => 'theme_mod',
        'sanitize_callback' => 'eyepress_lite_sanitize_checkbox',
        'transport'     => 'refresh',
    ));
    
    $wp_customize->add_control('eyepress_lite_animations', array(
        'label'      => __('Enable Animations', 'eyepress-lite'),
        'section'    => 'eyepress_blog_section',
        'settings'   => 'eyepress_lite_animations',
        'type'       => 'checkbox',
    ));
}
add_action('customize_register', 'eyepress_lite_customize_register', 999);

// Sanitization functions
function eyepress_lite_sanitize_dark_mode($input) {
    $valid = array('system', 'light', 'dark');
    return in_array($input, $valid) ? $input : 'system';
}

function eyepress_lite_sanitize_checkbox($checked) {
    return ((isset($checked) && true == $checked) ? true : false);
}