/**
 * Eyepress Lite Main JavaScript
 * 
 * This file contains custom JavaScript functionality for the Eyepress Lite theme.
 */

(function($) {
	'use strict';
	
	// Document ready
	$(document).ready(function() {
		
		// Add dark mode toggle functionality
		function initDarkModeToggle() {
			const toggleButton = $('#dark-mode-toggle');
			
			if (toggleButton.length) {
				toggleButton.on('click', function(e) {
					e.preventDefault();
					$('body').toggleClass('dark-mode');
					
					// Save preference to localStorage
					if ($('body').hasClass('dark-mode')) {
						localStorage.setItem('eyepressDarkMode', 'enabled');
					} else {
						localStorage.setItem('eyepressDarkMode', 'disabled');
					}
				});
				
				// Check for saved preference
				const savedMode = localStorage.getItem('eyepressDarkMode');
				if (savedMode === 'enabled') {
					$('body').addClass('dark-mode');
				} else if (savedMode === 'disabled') {
					$('body').removeClass('dark-mode');
				} else {
					// Use theme setting if no saved preference
					if (typeof eyepressLiteSettings !== 'undefined') {
						const themeSetting = eyepressLiteSettings.dark_mode_default;
						if (themeSetting === 'dark') {
							$('body').addClass('dark-mode');
						} else if (themeSetting === 'light') {
							$('body').removeClass('dark-mode');
						} else {
							// System default
							if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
								$('body').addClass('dark-mode');
							}
						}
					} else {
						// Fallback to system preference
						if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
							$('body').addClass('dark-mode');
						}
					}
				}
			}
		}
		
		// Initialize smooth scrolling for anchor links
		function initSmoothScrolling() {
			$('a[href*="#"]:not([href="#"])').on('click', function() {
				if (location.pathname.replace(/^\//, '') == this.pathname.replace(/^\//, '') && 
					location.hostname == this.hostname) {
					var target = $(this.hash);
					target = target.length ? target : $('[name=' + this.hash.slice(1) + ']');
					if (target.length) {
						$('html, body').animate({
							scrollTop: target.offset().top - 100
						}, 1000);
						return false;
					}
				}
			});
		}
		
		// Enhanced sticky header functionality
		function initStickyHeader() {
			const header = $('#active-sticky');
			if (header.length) {
				let lastScrollTop = 0;
				$(window).on('scroll', function() {
					const scrollTop = $(this).scrollTop();
					
					if (scrollTop > 100) {
						header.addClass('scrolled');
					} else {
						header.removeClass('scrolled');
					}
					
					// Hide header when scrolling down, show when scrolling up
					if (scrollTop > lastScrollTop && scrollTop > 200) {
						header.addClass('hidden');
					} else {
						header.removeClass('hidden');
					}
					
					lastScrollTop = scrollTop;
				});
			}
		}
		
		// Initialize all functions
		initDarkModeToggle();
		initSmoothScrolling();
		initStickyHeader();
		
		// Add animation classes to elements when they come into view
		function animateOnScroll() {
			$('.animate-on-scroll').each(function() {
				const elementPos = $(this).offset().top;
				const topOfWindow = $(window).scrollTop();
				const windowHeight = $(window).height();
				
				if (elementPos < topOfWindow + windowHeight - 100) {
					$(this).addClass('animated');
				}
			});
		}
		
		// Run on scroll
		$(window).on('scroll', function() {
			animateOnScroll();
		});
		
		// Initial check
		animateOnScroll();
	});
	
})(jQuery);