<?php
if ( ! get_theme_mod( 'expert_coaching_enable_counter_section', false ) ) {
	return;
}

$section_content = array();
$section_content = apply_filters( 'expert_coaching_counter_section_content', $section_content );

expert_coaching_render_counter_section( $section_content );

/**
 * Render Counter Section
 */
function expert_coaching_render_counter_section( $section_content ) {

	$section_title    = get_theme_mod( 'expert_coaching_counter_title', __( 'Counter', 'expert-coaching' ) );
	$section_subtitle = get_theme_mod( 'expert_coaching_counter_subtitle', '' );
	?>
	<section id="expert_coaching_counter_section" class="ascendoor-coach-frontpage-section expert-coaching-counter-section counter-style-3">
		<?php
		if ( is_customize_preview() ) :
			expert_coaching_section_link( 'expert_coaching_counter_section' );
		endif;
		?>
		<?php if ( ! empty( $section_title || $section_subtitle ) ) : ?>
			<div class="ascendoor-wrapper">
				<div class="section-header-subtitle">
					<h3 class="section-title"><?php echo esc_html( $section_title ); ?></h3>
					<p class="section-subtitle"><?php echo esc_html( $section_subtitle ); ?></p>
				</div>
			</div>
		<?php endif; ?>
		<div class="ascendoor-wrapper">
			<div class="expert-coaching-counter-details">
				<div class="expert-coaching-section-body">
					<div class="expert-coaching-counter-wrapper">
						<?php
						for ( $i = 1; $i <= 4; $i++ ) {
							$icon         = get_theme_mod( 'expert_coaching_counter_icon_' . $i );
							$label        = get_theme_mod( 'expert_coaching_counter_label_' . $i );
							$value        = get_theme_mod( 'expert_coaching_counter_value_' . $i );
							$value_suffix = get_theme_mod( 'expert_coaching_counter_value_suffix_' . $i );
							?>
							<div class="expert-coaching-counter-single wow fadeInUp" data-wow-delay="<?php echo esc_attr( $i * 200 ); ?>ms">
								<?php if ( ! empty( $icon ) ) { ?>
									<div class="expert-coaching-counter-img">
										<img src="<?php echo esc_url( $icon ); ?>" alt="<?php echo esc_attr( $label ); ?>">
									</div>
								<?php } ?>
								<div class="expert-coaching-counter-txt">
									<h3>
										<span class="count" data-count="<?php echo esc_attr( $value ); ?>"></span><span class="suffix"><?php echo esc_html( $value_suffix ); ?></span>
									</h3>
									<p><?php echo esc_html( $label ); ?></p>
								</div>
							</div>
							<?php
						}
						?>
					</div>      
				</div>
			</div>
		</div>
	</section>


	<?php

}
