<?php
/**
 * Team Section
 *
 * @package Expert Coaching
 */

$wp_customize->add_section(
	'expert_coaching_team_section',
	array(
		'panel'    => 'ascendoor_coach_front_page_options',
		'title'    => esc_html__( 'Team Section', 'expert-coaching' ),
		'priority' => 48,
	)
);

// Team Section - Enable Section.
$wp_customize->add_setting(
	'expert_coaching_enable_team_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'ascendoor_coach_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Ascendoor_Coach_Toggle_Switch_Custom_Control(
		$wp_customize,
		'expert_coaching_enable_team_section',
		array(
			'label'    => esc_html__( 'Enable Team Section', 'expert-coaching' ),
			'section'  => 'expert_coaching_team_section',
			'settings' => 'expert_coaching_enable_team_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'expert_coaching_enable_team_section',
		array(
			'selector' => '#expert_coaching_team_section .section-link',
			'settings' => 'expert_coaching_enable_team_section',
		)
	);
}

// Team Section - Section Title.
$wp_customize->add_setting(
	'expert_coaching_team_section_title',
	array(
		'default'           => __( 'Our Team', 'expert-coaching' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'expert_coaching_team_section_title',
	array(
		'label'           => esc_html__( 'Section Title', 'expert-coaching' ),
		'section'         => 'expert_coaching_team_section',
		'settings'        => 'expert_coaching_team_section_title',
		'type'            => 'text',
		'active_callback' => 'expert_coaching_is_team_section_enabled',
	)
);

// Team Section - Section Text.
$wp_customize->add_setting(
	'expert_coaching_team_section_text',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'expert_coaching_team_section_text',
	array(
		'label'           => esc_html__( 'Section Text', 'expert-coaching' ),
		'section'         => 'expert_coaching_team_section',
		'settings'        => 'expert_coaching_team_section_text',
		'type'            => 'text',
		'active_callback' => 'expert_coaching_is_team_section_enabled',
	)
);

// Team Section - Content Type.
$wp_customize->add_setting(
	'expert_coaching_team_content_type',
	array(
		'default'           => 'page',
		'sanitize_callback' => 'ascendoor_coach_sanitize_select',
	)
);

$wp_customize->add_control(
	'expert_coaching_team_content_type',
	array(
		'label'           => esc_html__( 'Select Content Type', 'expert-coaching' ),
		'section'         => 'expert_coaching_team_section',
		'settings'        => 'expert_coaching_team_content_type',
		'type'            => 'select',
		'active_callback' => 'expert_coaching_is_team_section_enabled',
		'choices'         => array(
			'page' => esc_html__( 'Page', 'expert-coaching' ),
			'post' => esc_html__( 'Post', 'expert-coaching' ),
		),
	)
);

for ( $i = 1; $i <= 3; $i++ ) {
	// Team Section - Select Post.
	$wp_customize->add_setting(
		'expert_coaching_team_content_post_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'expert_coaching_team_content_post_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Post %d', 'expert-coaching' ), $i ),
			'section'         => 'expert_coaching_team_section',
			'settings'        => 'expert_coaching_team_content_post_' . $i,
			'active_callback' => 'expert_coaching_is_team_section_and_content_type_post_enabled',
			'type'            => 'select',
			'choices'         => ascendoor_coach_get_post_choices(),
		)
	);

	// Team Section - Select Page.
	$wp_customize->add_setting(
		'expert_coaching_team_content_page_' . $i,
		array(
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'expert_coaching_team_content_page_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Select Page %d', 'expert-coaching' ), $i ),
			'section'         => 'expert_coaching_team_section',
			'settings'        => 'expert_coaching_team_content_page_' . $i,
			'active_callback' => 'expert_coaching_is_team_section_and_content_type_page_enabled',
			'type'            => 'select',
			'choices'         => ascendoor_coach_get_page_choices(),
		)
	);

	// Team Section - Designation.
	$wp_customize->add_setting(
		'expert_coaching_team_designation_' . $i,
		array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'expert_coaching_team_designation_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Designation %d', 'expert-coaching' ), $i ),
			'section'         => 'expert_coaching_team_section',
			'settings'        => 'expert_coaching_team_designation_' . $i,
			'active_callback' => 'expert_coaching_is_team_section_enabled',
		)
	);

	// Team Section - Social Links.
	$wp_customize->add_setting(
		'expert_coaching_team_social_links_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'esc_url_raw',
		)
	);
	$wp_customize->add_control(
		new Expert_Coaching_Sortable_Repeater_Custom_Control(
			$wp_customize,
			'expert_coaching_team_social_links_' . $i,
			array(
				'label'           => sprintf( esc_html__( 'Social Icons %d', 'expert-coaching' ), $i ),
				'section'         => 'expert_coaching_team_section',
				'button_labels'   => array(
					'add' => __( 'Add', 'expert-coaching' ),
				),
				'active_callback' => 'expert_coaching_is_team_section_enabled',
			)
		)
	);
}

// Team Section - Button Label.
$wp_customize->add_setting(
	'expert_coaching_team_button_label',
	array(
		'default'           => __( 'View All', 'expert-coaching' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'expert_coaching_team_button_label',
	array(
		'label'           => esc_html__( 'Button Label', 'expert-coaching' ),
		'section'         => 'expert_coaching_team_section',
		'settings'        => 'expert_coaching_team_button_label',
		'type'            => 'text',
		'active_callback' => 'expert_coaching_is_team_section_enabled',
	)
);

// Team Section - Button Link.
$wp_customize->add_setting(
	'expert_coaching_team_button_link',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'expert_coaching_team_button_link',
	array(
		'label'           => esc_html__( 'Button Link', 'expert-coaching' ),
		'section'         => 'expert_coaching_team_section',
		'settings'        => 'expert_coaching_team_button_link',
		'type'            => 'url',
		'active_callback' => 'expert_coaching_is_team_section_enabled',
	)
);
