<?php
/**
 * Featured Video Section
 *
 * @package Expert Coaching
 */

$wp_customize->add_section(
	'expert_coaching_featured_video_section',
	array(
		'panel'    => 'ascendoor_coach_front_page_options',
		'title'    => esc_html__( 'Featured Video Section', 'expert-coaching' ),
		'priority' => 42,
	)
);

// Featured Video Section - Enable Section.
$wp_customize->add_setting(
	'expert_coaching_enable_featured_video_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'ascendoor_coach_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Ascendoor_Coach_Toggle_Switch_Custom_Control(
		$wp_customize,
		'expert_coaching_enable_featured_video_section',
		array(
			'label'    => esc_html__( 'Enable Featured Video Section', 'expert-coaching' ),
			'section'  => 'expert_coaching_featured_video_section',
			'settings' => 'expert_coaching_enable_featured_video_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'expert_coaching_enable_featured_video_section',
		array(
			'selector' => '#expert_coaching_featured_video_section .section-link',
			'settings' => 'expert_coaching_enable_featured_video_section',
		)
	);
}

// Featured Video Section - Section Title.
$wp_customize->add_setting(
	'expert_coaching_featured_video_title',
	array(
		'default'           => __( 'Watch the Video', 'expert-coaching' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'expert_coaching_featured_video_title',
	array(
		'label'           => esc_html__( 'Section Title', 'expert-coaching' ),
		'section'         => 'expert_coaching_featured_video_section',
		'settings'        => 'expert_coaching_featured_video_title',
		'type'            => 'text',
		'active_callback' => 'expert_coaching_is_featured_video_section_enabled',
	)
);

// Featured Video Section - Section Text.
$wp_customize->add_setting(
	'expert_coaching_featured_video_text',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'expert_coaching_featured_video_text',
	array(
		'label'           => esc_html__( 'Section Text', 'expert-coaching' ),
		'section'         => 'expert_coaching_featured_video_section',
		'settings'        => 'expert_coaching_featured_video_text',
		'type'            => 'text',
		'active_callback' => 'expert_coaching_is_featured_video_section_enabled',
	)
);

// Featured Video Section - Section Short Description.
$wp_customize->add_setting(
	'expert_coaching_featured_video_short_description',
	array(
		'default'           => '',
		'sanitize_callback' => 'wp_kses_post',
	)
);

$wp_customize->add_control(
	'expert_coaching_featured_video_short_description',
	array(
		'label'           => esc_html__( 'Section Short Description', 'expert-coaching' ),
		'section'         => 'expert_coaching_featured_video_section',
		'settings'        => 'expert_coaching_featured_video_short_description',
		'type'            => 'textarea',
		'active_callback' => 'expert_coaching_is_featured_video_section_enabled',
	)
);

// Featured Video Section - Image.
$wp_customize->add_setting(
	'expert_coaching_featured_video_section_image',
	array(
		'sanitize_callback' => 'ascendoor_coach_sanitize_image',
	)
);

$wp_customize->add_control(
	new WP_Customize_Image_Control(
		$wp_customize,
		'expert_coaching_featured_video_section_image',
		array(
			'label'           => esc_html__( 'Section Image', 'expert-coaching' ),
			'section'         => 'expert_coaching_featured_video_section',
			'settings'        => 'expert_coaching_featured_video_section_image',
			'active_callback' => 'expert_coaching_is_featured_video_section_enabled',
		)
	)
);

// Featured Video Section - Video Link.
$wp_customize->add_setting(
	'expert_coaching_featured_video_video_link',
	array(
		'default'           => '',
		'sanitize_callback' => 'esc_url_raw',
	)
);

$wp_customize->add_control(
	'expert_coaching_featured_video_video_link',
	array(
		'label'           => esc_html__( 'Video Link', 'expert-coaching' ),
		'section'         => 'expert_coaching_featured_video_section',
		'settings'        => 'expert_coaching_featured_video_video_link',
		'type'            => 'url',
		'active_callback' => 'expert_coaching_is_featured_video_section_enabled',
	)
);
