<?php
/**
 * Counter Section
 *
 * @package Expert Coaching
 */

$wp_customize->add_section(
	'expert_coaching_counter_section',
	array(
		'panel'    => 'ascendoor_coach_front_page_options',
		'title'    => esc_html__( 'Counter Section', 'expert-coaching' ),
		'priority' => 45,
	)
);

// Counter Section - Enable Section.
$wp_customize->add_setting(
	'expert_coaching_enable_counter_section',
	array(
		'default'           => false,
		'sanitize_callback' => 'ascendoor_coach_sanitize_switch',
	)
);

$wp_customize->add_control(
	new Ascendoor_Coach_Toggle_Switch_Custom_Control(
		$wp_customize,
		'expert_coaching_enable_counter_section',
		array(
			'label'    => esc_html__( 'Enable Counter Section', 'expert-coaching' ),
			'section'  => 'expert_coaching_counter_section',
			'settings' => 'expert_coaching_enable_counter_section',
		)
	)
);

if ( isset( $wp_customize->selective_refresh ) ) {
	$wp_customize->selective_refresh->add_partial(
		'expert_coaching_enable_counter_section',
		array(
			'selector' => '#expert_coaching_counter_section .section-link',
			'settings' => 'expert_coaching_enable_counter_section',
		)
	);
}

// Counter Section - Section Title.
$wp_customize->add_setting(
	'expert_coaching_counter_title',
	array(
		'default'           => __( 'Counter', 'expert-coaching' ),
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'expert_coaching_counter_title',
	array(
		'label'           => esc_html__( 'Section Title', 'expert-coaching' ),
		'section'         => 'expert_coaching_counter_section',
		'settings'        => 'expert_coaching_counter_title',
		'type'            => 'text',
		'active_callback' => 'expert_coaching_is_counter_section_enabled',
	)
);

// Counter Section - Section Sub Title.
$wp_customize->add_setting(
	'expert_coaching_counter_subtitle',
	array(
		'default'           => '',
		'sanitize_callback' => 'sanitize_text_field',
	)
);

$wp_customize->add_control(
	'expert_coaching_counter_subtitle',
	array(
		'label'           => esc_html__( 'Section Subtitle', 'expert-coaching' ),
		'section'         => 'expert_coaching_counter_section',
		'settings'        => 'expert_coaching_counter_subtitle',
		'type'            => 'text',
		'active_callback' => 'expert_coaching_is_counter_section_enabled',
	)
);

for ( $i = 1; $i <= 4; $i++ ) {

	// Counter Section - Counter Icon.
	$wp_customize->add_setting(
		'expert_coaching_counter_icon_' . $i,
		array(
			'sanitize_callback' => 'ascendoor_coach_sanitize_image',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'expert_coaching_counter_icon_' . $i,
			array(
				'label'           => sprintf( esc_html__( 'Icon %d', 'expert-coaching' ), $i ),
				'section'         => 'expert_coaching_counter_section',
				'settings'        => 'expert_coaching_counter_icon_' . $i,
				'active_callback' => 'expert_coaching_is_counter_section_enabled',
			)
		)
	);

	// Counter Section - Counter Label.
	$wp_customize->add_setting(
		'expert_coaching_counter_label_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'expert_coaching_counter_label_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Label %d', 'expert-coaching' ), $i ),
			'section'         => 'expert_coaching_counter_section',
			'settings'        => 'expert_coaching_counter_label_' . $i,
			'type'            => 'text',
			'active_callback' => 'expert_coaching_is_counter_section_enabled',
		)
	);

	// Counter Section - Counter Value.
	$wp_customize->add_setting(
		'expert_coaching_counter_value_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'absint',
		)
	);

	$wp_customize->add_control(
		'expert_coaching_counter_value_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Value %d', 'expert-coaching' ), $i ),
			'section'         => 'expert_coaching_counter_section',
			'settings'        => 'expert_coaching_counter_value_' . $i,
			'type'            => 'number',
			'input_attrs'     => array( 'min' => 1 ),
			'active_callback' => 'expert_coaching_is_counter_section_enabled',
		)
	);

	// Counter Section - Counter Suffix.
	$wp_customize->add_setting(
		'expert_coaching_counter_value_suffix_' . $i,
		array(
			'default'           => '',
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		'expert_coaching_counter_value_suffix_' . $i,
		array(
			'label'           => sprintf( esc_html__( 'Value Suffix %d', 'expert-coaching' ), $i ),
			'section'         => 'expert_coaching_counter_section',
			'settings'        => 'expert_coaching_counter_value_suffix_' . $i,
			'type'            => 'text',
			'active_callback' => 'expert_coaching_is_counter_section_enabled',
		)
	);

	// Counter Section - Horizontal Line.
	$wp_customize->add_setting(
		'expert_coaching_counter_horizontal_line' . $i,
		array(
			'sanitize_callback' => 'sanitize_text_field',
		)
	);

	$wp_customize->add_control(
		new Ascendoor_Coach_Customize_Horizontal_Line(
			$wp_customize,
			'expert_coaching_counter_horizontal_line' . $i,
			array(
				'section'         => 'expert_coaching_counter_section',
				'settings'        => 'expert_coaching_counter_horizontal_line' . $i,
				'active_callback' => 'expert_coaching_is_counter_section_enabled',
				'type'            => 'hr',
			)
		)
	);

}
