<?php
/**
 * Theme Customizer
 *
 * @package Expert_Coaching
 */

function expert_coaching_customize_register( $wp_customize ) {

	// Featured Video Section.
	require get_theme_file_path() . '/inc/customizer/featured-video.php';

	// Counter Section.
	require get_theme_file_path() . '/inc/customizer/counter.php';

	// Team Section.
	require get_theme_file_path() . '/inc/customizer/team.php';

	// About Section - Background Image.
	$wp_customize->add_setting(
		'expert_coaching_about_background_image',
		array(
			'sanitize_callback' => 'ascendoor_coach_sanitize_image',
		)
	);

	$wp_customize->add_control(
		new WP_Customize_Image_Control(
			$wp_customize,
			'expert_coaching_about_background_image',
			array(
				'label'           => esc_html__( 'Background Image', 'expert-coaching' ),
				'section'         => 'ascendoor_coach_about_section',
				'settings'        => 'expert_coaching_about_background_image',
				'active_callback' => 'ascendoor_coach_is_about_section_enabled',
				'priority'        => 15,
			)
		)
	);

	// Upsell Section.
	$wp_customize->add_section(
		new Expert_Coaching_Upsell_Section(
			$wp_customize,
			'upsell_sections',
			array(
				'title'            => __( 'Expert Coaching Pro', 'expert-coaching' ),
				'button_text'      => __( 'Buy Pro', 'expert-coaching' ),
				'url'              => 'https://ascendoor.com/themes/expert-coaching/',
				'background_color' => '#D20A0A',
				'text_color'       => '#fff',
				'priority'         => 0,
			)
		)
	);

}
add_action( 'customize_register', 'expert_coaching_customize_register' );

function expert_coaching_customize_preview_js() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_script( 'expert-coaching-customizer', get_stylesheet_directory_uri() . '/assets/js/customizer' . $min . '.js', array( 'customize-preview', 'ascendoor-coach-customizer' ), '1.0.0', true );
}
add_action( 'customize_preview_init', 'expert_coaching_customize_preview_js' );

function expert_coaching_custom_control_scripts() {
	// Append .min if SCRIPT_DEBUG is false.
	$min = ( defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ) ? '' : '.min';

	wp_enqueue_style( 'expert-coaching-custom-controls-css', get_stylesheet_directory_uri() . '/assets/css/custom-controls' . $min . '.css', array( 'ascendoor-coach-custom-controls-css' ), '1.0.0', 'all' );
	wp_enqueue_script( 'expert-coaching-custom-controls-js', get_stylesheet_directory_uri() . '/assets/js/custom-controls' . $min . '.js', array( 'ascendoor-coach-custom-controls-js', 'jquery', 'jquery-ui-core' ), '1.0.0', true );
}
add_action( 'customize_controls_enqueue_scripts', 'expert_coaching_custom_control_scripts' );

/*=====================Active Callback=================*/

// Counter section.
function expert_coaching_is_counter_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'expert_coaching_enable_counter_section' )->value() );
}

// Team section.
function expert_coaching_is_team_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'expert_coaching_enable_team_section' )->value() );
}
function expert_coaching_is_team_section_and_content_type_post_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'expert_coaching_team_content_type' )->value();
	return ( expert_coaching_is_team_section_enabled( $control ) && ( 'post' === $content_type ) );
}
function expert_coaching_is_team_section_and_content_type_page_enabled( $control ) {
	$content_type = $control->manager->get_setting( 'expert_coaching_team_content_type' )->value();
	return ( expert_coaching_is_team_section_enabled( $control ) && ( 'page' === $content_type ) );
}

// Featured Video section.
function expert_coaching_is_featured_video_section_enabled( $control ) {
	return ( $control->manager->get_setting( 'expert_coaching_enable_featured_video_section' )->value() );
}
